/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import iso.std.iso_iec._24727.tech.schema.ActionType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.TransformerException;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.Context;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.binding.tctoken.HttpGetTask;
import org.openecard.binding.tctoken.PAOSTask;
import org.openecard.binding.tctoken.RedirectCertificateValidator;
import org.openecard.binding.tctoken.ResourceContext;
import org.openecard.binding.tctoken.ResourceException;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenRequest;
import org.openecard.binding.tctoken.TCTokenResponse;
import org.openecard.binding.tctoken.ValidationError;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidAddressException;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.binding.tctoken.ex.NonGuiException;
import org.openecard.binding.tctoken.ex.SecurityViolationException;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.I18nKey;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.util.HandlerUtils;
import org.openecard.common.util.Pair;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.message.DialogType;
import org.openecard.transport.paos.PAOSConnectionException;
import org.openecard.transport.paos.PAOSException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TCTokenHandler.class);
    private static final I18n LANG_TR = I18n.getTranslation("tr03112");
    private static final I18n LANG_TOKEN = I18n.getTranslation("tctoken");
    private static final I18n LANG_PIN = I18n.getTranslation("pinplugin");
    private static final I18n LANG_PACE = I18n.getTranslation("pace");
    private static final String ERROR_CARD_REMOVED = "action.error.card.removed";
    private final String pin;
    private final String puk;
    private final CardStateMap cardStates;
    private final Dispatcher dispatcher;
    private final UserConsent gui;
    private final CardRecognition rec;
    private final AddonManager manager;
    private final EventDispatcher evManager;

    public TCTokenHandler(Context ctx) {
        this.cardStates = ctx.getCardStates();
        this.dispatcher = ctx.getDispatcher();
        this.gui = ctx.getUserConsent();
        this.rec = ctx.getRecognition();
        this.manager = ctx.getManager();
        this.evManager = ctx.getEventDispatcher();
        this.pin = LANG_PACE.translationForKey("pin", new Object[0]);
        this.puk = LANG_PACE.translationForKey("puk", new Object[0]);
    }

    private ConnectionHandleType prepareHandle(ConnectionHandleType connectionHandle) throws WSHelper.WSException {
        CardApplicationPath appPath = new CardApplicationPath();
        appPath.setCardAppPathRequest(connectionHandle);
        CardApplicationPathResponse appPathRes = (CardApplicationPathResponse)this.dispatcher.safeDeliver(appPath);
        WSHelper.checkResult(appPathRes);
        CardApplicationConnect appConnect = new CardApplicationConnect();
        List<CardApplicationPathType> pathRes = appPathRes.getCardAppPathResultSet().getCardApplicationPathResult();
        appConnect.setCardApplicationPath(pathRes.get(0));
        CardApplicationConnectResponse appConnectRes = (CardApplicationConnectResponse)this.dispatcher.safeDeliver(appConnect);
        connectionHandle = appConnectRes.getConnectionHandle();
        WSHelper.checkResult(appConnectRes);
        return connectionHandle;
    }

    private ConnectionHandleType ensureHandleIsUsable(ConnectionHandleType connectionHandle) throws WSHelper.WSException {
        connectionHandle = this.prepareHandle(connectionHandle);
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        dynCtx.put("connection_handle", HandlerUtils.copyHandle(connectionHandle));
        return connectionHandle;
    }

    private TCTokenResponse processBinding(TCTokenRequest tokenRequest, @Nullable ConnectionHandleType connectionHandle) throws PAOSException, DispatcherException {
        TCToken token = tokenRequest.getTCToken();
        try {
            String binding;
            TCTokenResponse response = new TCTokenResponse();
            response.setTCToken(token);
            response.setResult(WSHelper.makeResultOK());
            switch (binding = token.getBinding()) {
                case "urn:liberty:paos:2006-08": {
                    connectionHandle = this.ensureHandleIsUsable(connectionHandle);
                    List<String> supportedDIDs = this.getSupportedDIDs();
                    PAOSTask task = new PAOSTask(this.dispatcher, connectionHandle, supportedDIDs, tokenRequest, this.gui);
                    FutureTask<StartPAOSResponse> paosTask = new FutureTask<StartPAOSResponse>(task);
                    Thread paosThread = new Thread(paosTask, "PAOS");
                    paosThread.start();
                    if (!tokenRequest.isTokenFromObject()) {
                        TCTokenHandler.waitForTask(paosTask);
                    }
                    response.setBindingTask(paosTask);
                    break;
                }
                case "urn:ietf:rfc:2616": {
                    connectionHandle = this.ensureHandleIsUsable(connectionHandle);
                    HttpGetTask task = new HttpGetTask(this.dispatcher, connectionHandle, tokenRequest);
                    FutureTask<StartPAOSResponse> tlsTask = new FutureTask<StartPAOSResponse>(task);
                    Thread tlsThread = new Thread(tlsTask, "TLS Auth");
                    tlsThread.start();
                    TCTokenHandler.waitForTask(tlsTask);
                    response.setBindingTask(tlsTask);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported binding in TCToken.");
                }
            }
            return response;
        }
        catch (WSHelper.WSException ex) {
            String msg = "Failed to connect to card.";
            LOG.error(msg, ex);
            throw new DispatcherException(msg, ex);
        }
    }

    public static void disconnectHandle(Dispatcher dispatcher, ConnectionHandleType connectionHandle) {
        CardApplicationDisconnect appDis = new CardApplicationDisconnect();
        appDis.setConnectionHandle(connectionHandle);
        appDis.setAction(ActionType.RESET);
        dispatcher.safeDeliver(appDis);
    }

    public static void killUserConsent() {
        DynamicContext ctx = DynamicContext.getInstance("tr03112");
        Object navObj = ctx.get("user_consent_navigator");
        if (navObj instanceof UserConsentNavigator) {
            UserConsentNavigator nav = (UserConsentNavigator)navObj;
            nav.close();
        }
    }

    public TCTokenResponse handleActivate(TCTokenRequest request) throws InvalidRedirectUrlException, SecurityViolationException, NonGuiException {
        boolean isObjectActivation;
        TCToken token = request.getTCToken();
        if (LOG.isDebugEnabled()) {
            try {
                WSMarshaller m = WSMarshallerFactory.createInstance();
                LOG.debug("TCToken:\n{}", (Object)m.doc2str(m.marshal(token)));
            }
            catch (TransformerException | WSMarshallerException m) {
                // empty catch block
            }
        }
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        boolean performChecks = TCTokenHandler.isPerformTR03112Checks(request);
        if (!performChecks) {
            LOG.warn("Checks according to BSI TR03112 3.4.2, 3.4.4 (TCToken specific) and 3.4.5 are disabled.");
        }
        boolean bl = isObjectActivation = request.getTCTokenURL() == null;
        if (isObjectActivation) {
            LOG.warn("Checks according to BSI TR03112 3.4.4 (TCToken specific) are disabled.");
        }
        dynCtx.put("tctoken_checks", performChecks);
        dynCtx.put("object_activation", isObjectActivation);
        dynCtx.put("tctoken_server_certificates", request.getCertificates());
        ConnectionHandleType connectionHandle = null;
        TCTokenResponse response = new TCTokenResponse();
        response.setTCToken(token);
        byte[] requestedContextHandle = request.getContextHandle();
        String ifdName = request.getIFDName();
        BigInteger requestedSlotIndex = request.getSlotIndex();
        ConnectionHandleType requestedHandle = new ConnectionHandleType();
        requestedHandle.setContextHandle(requestedContextHandle);
        requestedHandle.setIFDName(ifdName);
        requestedHandle.setSlotIndex(requestedSlotIndex);
        Set<CardStateEntry> matchingHandles = this.cardStates.getMatchingEntries(requestedHandle);
        if (!matchingHandles.isEmpty()) {
            connectionHandle = matchingHandles.toArray(new CardStateEntry[0])[0].handleCopy();
        }
        if (connectionHandle == null) {
            String msg = LANG_TOKEN.translationForKey("cancel", new Object[0]);
            LOG.error(msg);
            response.setResult(WSHelper.makeResultError("cancellationByUser", msg));
            response = TCTokenHandler.determineRefreshURL(request, response);
            response.finishResponse(true);
            return response;
        }
        try {
            response = this.processBinding(request, connectionHandle);
            response = TCTokenHandler.determineRefreshURL(request, response);
            response.finishResponse(isObjectActivation);
            return response;
        }
        catch (DispatcherException w) {
            LOG.error(w.getMessage(), w);
            response.setResultCode(BindingResultCode.INTERNAL_ERROR);
            response.setResult(WSHelper.makeResultError("clientError", w.getMessage()));
            this.showErrorMessage(w.getMessage());
            throw new NonGuiException((BindingResult)response, w.getMessage(), w);
        }
        catch (PAOSException w) {
            String errorMsg;
            LOG.error(w.getMessage(), w);
            Throwable innerException = w.getCause();
            if (innerException == null) {
                innerException = w;
            } else if (innerException instanceof ExecutionException) {
                innerException = innerException.getCause();
            }
            switch (errorMsg = innerException.getLocalizedMessage()) {
                case "The target server failed to respond": {
                    errorMsg = LANG_TR.translationForKey(ErrorTranslations.NO_RESPONSE_FROM_SERVER, new Object[0]);
                    break;
                }
                case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError ==> Unknown eCard exception occurred.": {
                    errorMsg = LANG_TR.translationForKey(ErrorTranslations.UNKNOWN_ECARD_ERROR, new Object[0]);
                    break;
                }
                case "Internal TLS error, this could be an attack": {
                    errorMsg = LANG_TR.translationForKey(ErrorTranslations.INTERNAL_TLS_ERROR, new Object[0]);
                }
            }
            if (innerException instanceof WSHelper.WSException) {
                WSHelper.WSException ex = (WSHelper.WSException)innerException;
                errorMsg = this.createResponseFromWsEx(ex, response);
            } else if (innerException instanceof PAOSConnectionException) {
                response.setResult(WSHelper.makeResultError("trustedChannelEstablishmentFailed", w.getLocalizedMessage()));
            } else {
                errorMsg = this.createMessageFromUnknownError(w);
                response.setResult(WSHelper.makeResultError("clientError", w.getMessage()));
            }
            this.showErrorMessage(errorMsg);
            try {
                response = TCTokenHandler.determineRefreshURL(request, response);
                response.finishResponse(true);
            }
            catch (InvalidRedirectUrlException ex) {
                LOG.error(ex.getMessage(), ex);
                response.setResultCode(BindingResultCode.INTERNAL_ERROR);
                response.setResult(WSHelper.makeResultError("clientError", ex.getLocalizedMessage()));
                throw new NonGuiException((BindingResult)response, ex.getMessage(), ex);
            }
            catch (SecurityViolationException ex) {
                String msg2 = "The RefreshAddress contained in the TCToken is invalid. Redirecting to the CommunicationErrorAddress.";
                LOG.error(msg2, ex);
                response.setResultCode(BindingResultCode.REDIRECT);
                response.setResult(WSHelper.makeResultError("communicationError", msg2));
                response.addAuxResultData("org.openecard.addon.bind.aux_data.redirect_location", ex.getBindingResult().getAuxResultData().get("org.openecard.addon.bind.aux_data.redirect_location"));
            }
            return response;
        }
    }

    private static void waitForTask(Future<?> task) throws PAOSException, DispatcherException {
        try {
            task.get();
        }
        catch (InterruptedException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new PAOSException(ex);
        }
        catch (ExecutionException ex) {
            LOG.error(ex.getMessage(), ex);
            if (ex.getCause() instanceof PAOSException) {
                throw (PAOSException)ex.getCause();
            }
            if (ex.getCause() instanceof DispatcherException) {
                throw (DispatcherException)ex.getCause();
            }
            throw new PAOSException(ex);
        }
    }

    private static TCTokenResponse determineRefreshURL(TCTokenRequest request, TCTokenResponse response) throws InvalidRedirectUrlException, SecurityViolationException {
        try {
            String endpointStr = response.getRefreshAddress();
            URL endpoint = new URL(endpointStr);
            DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
            Object objectActivation = dynCtx.get("object_activation");
            if (objectActivation instanceof Boolean && ((Boolean)objectActivation).booleanValue()) {
                return response;
            }
            boolean redirectChecks = TCTokenHandler.isPerformTR03112Checks(request);
            RedirectCertificateValidator verifier = new RedirectCertificateValidator(redirectChecks);
            ResourceContext ctx = ResourceContext.getStream(endpoint, verifier);
            ctx.closeStream();
            List<Pair<URL, TlsServerCertificate>> resultPoints = ctx.getCerts();
            Pair<URL, TlsServerCertificate> last = resultPoints.get(resultPoints.size() - 1);
            endpoint = (URL)last.p1;
            dynCtx.put("is_refresh_url_valid", true);
            LOG.debug("Setting redirect address to '{}'.", (Object)endpoint);
            response.setRefreshAddress(endpoint.toString());
            return response;
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(LANG_TR.translationForKey(ErrorTranslations.REFRESH_URL_ERROR, new Object[0]), ex);
        }
        catch (IOException | ResourceException | ValidationError | InvalidAddressException ex) {
            String code = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#communicationError";
            String communicationErrorAddress = response.getTCToken().getComErrorAddressWithParams(code);
            if (communicationErrorAddress != null && !communicationErrorAddress.isEmpty()) {
                throw new SecurityViolationException(communicationErrorAddress, (I18nKey)ErrorTranslations.REFRESH_DETERMINATION_FAILED, (Throwable)ex, new Object[0]);
            }
            throw new InvalidRedirectUrlException((I18nKey)ErrorTranslations.REFRESH_DETERMINATION_FAILED, (Throwable)ex, new Object[0]);
        }
    }

    private List<String> getSupportedDIDs() {
        TreeSet<String> result = new TreeSet<String>();
        AddonRegistry registry = this.manager.getRegistry();
        Set<AddonSpecification> addons = registry.listAddons();
        for (AddonSpecification addon : addons) {
            for (ProtocolPluginSpecification proto : addon.getSalActions()) {
                result.add(proto.getUri());
            }
        }
        return new ArrayList<String>(result);
    }

    private static boolean isPerformTR03112Checks(TCTokenRequest tcTokenRequest) {
        boolean activationChecks = true;
        if (!tcTokenRequest.getCardType().equals("http://bsi.bund.de/cif/npa.xml")) {
            activationChecks = false;
        }
        return activationChecks;
    }

    private void showBackgroundMessage(final String msg, final String title, final DialogType dialogType) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TCTokenHandler.this.gui.obtainMessageDialog().showMessageDialog(msg, title, dialogType);
            }
        }, "Background_MsgBox").start();
    }

    private void showErrorMessage(String errMsg) {
        String title = LANG_TR.translationForKey(ErrorTranslations.ERROR_TITLE, new Object[0]);
        String baseHeader = LANG_TR.translationForKey(ErrorTranslations.ERROR_HEADER, new Object[0]);
        String exceptionPart = LANG_TR.translationForKey(ErrorTranslations.ERROR_MSG_IND, new Object[0]);
        String removeCard = LANG_TR.translationForKey(ErrorTranslations.REMOVE_CARD, new Object[0]);
        String msg = String.format("%s\n\n%s\n%s\n\n%s", baseHeader, exceptionPart, errMsg, removeCard);
        this.showBackgroundMessage(msg, title, DialogType.ERROR_MESSAGE);
    }

    private String createResponseFromWsEx(WSHelper.WSException ex, TCTokenResponse response) {
        String errorMsg;
        switch (ex.getResultMinor()) {
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser": {
                errorMsg = LANG_TOKEN.translationForKey("cancel", new Object[0]);
                response.setResult(WSHelper.makeResultError("cancellationByUser", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#DocumentValidityVerificationFailed": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.CERT_ERROR, new Object[0]);
                response.setResult(WSHelper.makeResultError("clientError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.MESSAGE_CONTENT_INVALID, new Object[0]);
                response.setResult(WSHelper.makeResultError("clientError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.INTERNAL_ERROR, new Object[0]);
                response.setResult(WSHelper.makeResultError("serverError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#prerequisitesNotSatisfied": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.CERT_DESCRIPTION_CHECK_FAILED, new Object[0]);
                response.setResult(WSHelper.makeResultError("clientError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.ERROR_WHILE_AUTHENTICATION, new Object[0]);
                response.setResult(WSHelper.makeResultError("serverError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownConnectionHandle": {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.UNKNOWN_CONNECTION_HANDLE, new Object[0]);
                response.setResult(WSHelper.makeResultError("serverError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle": {
                errorMsg = LANG_PIN.translationForKey(ERROR_CARD_REMOVED, new Object[0]);
                response.setResult(WSHelper.makeResultError("clientError", errorMsg));
                break;
            }
            case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked": {
                errorMsg = LANG_PACE.translationForKey("step_error_pin_blocked", this.pin, this.pin, this.puk, this.pin);
                response.setResult(WSHelper.makeResultError("clientError", errorMsg));
                break;
            }
            default: {
                errorMsg = LANG_TR.translationForKey(ErrorTranslations.ERROR_WHILE_AUTHENTICATION, new Object[0]);
                response.setResult(WSHelper.makeResultError("serverError", errorMsg));
            }
        }
        return errorMsg;
    }

    private String createMessageFromUnknownError(@Nonnull PAOSException w) {
        String errorMsg = "\n";
        errorMsg = errorMsg + LANG_TR.translationForKey(ErrorTranslations.UNHANDLED_INNER_EXCEPTION, new Object[0]);
        errorMsg = errorMsg + "\n";
        errorMsg = errorMsg + w.getMessage();
        return errorMsg;
    }
}

