/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import generated.TCTokenType;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.binding.tctoken.TCTokenHacks;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.common.I18nKey;
import org.openecard.common.util.UrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCToken
extends TCTokenType {
    private static final Logger LOG = LoggerFactory.getLogger(TCToken.class);
    private boolean invalidPSK = false;

    public String getComErrorAddressWithParams(@Nonnull String minor) throws InvalidRedirectUrlException {
        try {
            String errorUrl = this.getCommunicationErrorAddress();
            URI url = TCToken.checkUrl(errorUrl);
            String result = UrlBuilder.fromUrl(url).queryParam("ResultMajor", "error").queryParamUrl("ResultMinor", TCTokenHacks.fixResultMinor(minor)).build().toString();
            return result;
        }
        catch (URISyntaxException ex) {
            LOG.error("Construction of redirect URL failed.", ex);
            throw new InvalidRedirectUrlException((I18nKey)ErrorTranslations.NO_URL, new Object[0]);
        }
    }

    protected boolean isInvalidPSK() {
        return this.invalidPSK;
    }

    protected void setInvalidPSK(boolean invalidPSK) {
        this.invalidPSK = invalidPSK;
    }

    private static URI checkUrl(@Nullable String urlStr) throws InvalidRedirectUrlException {
        if (urlStr != null && !urlStr.isEmpty()) {
            try {
                URI url = new URI(urlStr);
                return url;
            }
            catch (URISyntaxException ex) {
                LOG.error("No valid CommunicationErrorAddress provided.");
                throw new InvalidRedirectUrlException((I18nKey)ErrorTranslations.NO_URL, new Object[0]);
            }
        }
        LOG.error("No CommunicationErrorAddress to perform a redirect provided.");
        throw new InvalidRedirectUrlException((I18nKey)ErrorTranslations.NO_REDIRECT_AVAILABLE, new Object[0]);
    }
}

