/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.io;

import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpResponseFactory;
import org.openecard.apache.http.annotation.Contract;
import org.openecard.apache.http.annotation.ThreadingBehavior;
import org.openecard.apache.http.config.MessageConstraints;
import org.openecard.apache.http.impl.DefaultHttpResponseFactory;
import org.openecard.apache.http.impl.io.DefaultHttpResponseParser;
import org.openecard.apache.http.io.HttpMessageParser;
import org.openecard.apache.http.io.HttpMessageParserFactory;
import org.openecard.apache.http.io.SessionInputBuffer;
import org.openecard.apache.http.message.BasicLineParser;
import org.openecard.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

