/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.io;

import java.io.IOException;
import org.openecard.apache.http.ConnectionClosedException;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpRequestFactory;
import org.openecard.apache.http.ParseException;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.config.MessageConstraints;
import org.openecard.apache.http.impl.DefaultHttpRequestFactory;
import org.openecard.apache.http.impl.io.AbstractMessageParser;
import org.openecard.apache.http.io.SessionInputBuffer;
import org.openecard.apache.http.message.LineParser;
import org.openecard.apache.http.message.ParserCursor;
import org.openecard.apache.http.params.HttpParams;
import org.openecard.apache.http.util.Args;
import org.openecard.apache.http.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

