/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.tr03124.gui;

import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.List;
import java.util.Map;
import org.openecard.addon.Context;
import org.openecard.addons.tr03124.gui.CardSelectionStep;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Radiobox;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSelectionAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(CardSelectionAction.class);
    private final List<ConnectionHandleType> avCard;
    private final List<String> types;
    private final CardSelectionStep step;
    private final Context ctx;
    private String resultCardTypetName;

    public CardSelectionAction(CardSelectionStep step, List<ConnectionHandleType> availableCard, List<String> types, Context ctx) {
        super(step);
        this.avCard = availableCard;
        this.types = types;
        this.step = step;
        this.ctx = ctx;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        if (result.isOK()) {
            ExecutionResults results = oldResults.get(this.getStepID());
            OutputInfoUnit out = results.getResult("credentialSelectionBox");
            Radiobox rBox = (Radiobox)out;
            for (BoxItem item : rBox.getBoxItems()) {
                if (!item.isChecked()) continue;
                this.resultCardTypetName = item.getName();
                break;
            }
            if (this.resultCardTypetName != null) {
                return new StepActionResult(StepActionResultStatus.NEXT);
            }
            return new StepActionResult(StepActionResultStatus.REPEAT);
        }
        if (result.isReload()) {
            this.updateCards();
            this.step.update(this.avCard);
            if (this.avCard.isEmpty()) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
            return new StepActionResult(StepActionResultStatus.REPEAT);
        }
        return new StepActionResult(StepActionResultStatus.CANCEL);
    }

    public ConnectionHandleType getResult() {
        for (ConnectionHandleType handle : this.avCard) {
            if (!handle.getRecognitionInfo().getCardType().equals(this.resultCardTypetName)) continue;
            return handle;
        }
        return null;
    }

    private void updateCards() {
        this.avCard.clear();
        CardApplicationPath cap = new CardApplicationPath();
        cap.setCardAppPathRequest(new CardApplicationPathType());
        CardApplicationPathResponse resp = (CardApplicationPathResponse)this.ctx.getDispatcher().safeDeliver(cap);
        List<CardApplicationPathType> cards = resp.getCardAppPathResultSet().getCardApplicationPathResult();
        for (CardApplicationPathType path : cards) {
            CardApplicationConnect connect = new CardApplicationConnect();
            connect.setCardApplicationPath(path);
            CardApplicationConnectResponse conResp = (CardApplicationConnectResponse)this.ctx.getDispatcher().safeDeliver(connect);
            if (this.types.contains(conResp.getConnectionHandle().getRecognitionInfo().getCardType())) {
                this.avCard.add(conResp.getConnectionHandle());
                continue;
            }
            CardApplicationDisconnect disconnect = new CardApplicationDisconnect();
            disconnect.setConnectionHandle(conResp.getConnectionHandle());
            this.ctx.getDispatcher().safeDeliver(disconnect);
        }
    }
}

