/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.status;

import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.Context;
import org.openecard.addon.EventHandler;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.addons.status.StatusRequest;
import org.openecard.addons.status.StatusResponse;
import org.openecard.common.AppVersion;
import org.openecard.common.ECardConstants;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.ws.schema.Status;
import org.openecard.ws.schema.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusHandler {
    private static final Logger logger = LoggerFactory.getLogger(StatusHandler.class);
    private final CardStateMap cardStates;
    private final Dispatcher dispatcher;
    private final EventHandler eventHandler;
    private final List<String> protocols;
    private final CardRecognition rec;

    public StatusHandler(Context ctx) {
        this.cardStates = ctx.getCardStates();
        this.dispatcher = ctx.getDispatcher();
        this.eventHandler = ctx.getEventHandler();
        this.protocols = this.getProtocolInfo(ctx.getManager());
        this.rec = ctx.getRecognition();
    }

    public StatusResponse handleRequest(StatusRequest statusRequest) {
        Status status = new Status();
        StatusType.UserAgent ua = new StatusType.UserAgent();
        ua.setName(AppVersion.getName());
        ua.setVersionMajor(BigInteger.valueOf(AppVersion.getMajor()));
        ua.setVersionMinor(BigInteger.valueOf(AppVersion.getMinor()));
        ua.setVersionSubminor(BigInteger.valueOf(AppVersion.getPatch()));
        status.setUserAgent(ua);
        StatusType.SupportedAPIVersions apiVersion = new StatusType.SupportedAPIVersions();
        apiVersion.setName("http://www.bsi.bund.de/ecard/api");
        apiVersion.setVersionMajor(ECardConstants.ECARD_API_VERSION_MAJOR);
        apiVersion.setVersionMinor(ECardConstants.ECARD_API_VERSION_MINOR);
        apiVersion.setVersionSubminor(ECardConstants.ECARD_API_VERSION_SUBMINOR);
        status.getSupportedAPIVersions().add(apiVersion);
        List<CardInfoType> cifs = this.rec.getCardInfos();
        List<StatusType.SupportedCards> supportedCards = StatusHandler.getSupportedCards(this.protocols, cifs);
        status.getSupportedCards().addAll(supportedCards);
        status.getSupportedDIDProtocols().addAll(this.protocols);
        status.getConnectionHandle().addAll(this.getCardHandles());
        if (statusRequest.hasSessionIdentifier()) {
            String sessionIdentifier = statusRequest.getSessionIdentifier();
            this.eventHandler.addQueue(sessionIdentifier);
        }
        return new StatusResponse(status);
    }

    @Nonnull
    private static List<StatusType.SupportedCards> getSupportedCards(List<String> protocols, List<CardInfoType> cifs) {
        ArrayList<StatusType.SupportedCards> result = new ArrayList<StatusType.SupportedCards>();
        for (CardInfoType cif : cifs) {
            StatusType.SupportedCards supportedCard = new StatusType.SupportedCards();
            result.add(supportedCard);
            String name = cif.getCardType().getObjectIdentifier();
            supportedCard.setCardType(name);
            for (CardApplicationType app : cif.getApplicationCapabilities().getCardApplication()) {
                for (DIDInfoType did : app.getDIDInfo()) {
                    String proto = did.getDifferentialIdentity().getDIDProtocol();
                    if (!protocols.contains(proto) || supportedCard.getDIDProtocols().contains(proto)) continue;
                    supportedCard.getDIDProtocols().add(proto);
                }
            }
        }
        return result;
    }

    @Nonnull
    private List<String> getProtocolInfo(AddonManager manager) {
        TreeSet<String> result = new TreeSet<String>();
        AddonRegistry registry = manager.getRegistry();
        Set<AddonSpecification> addons = registry.listAddons();
        for (AddonSpecification addon : addons) {
            for (ProtocolPluginSpecification proto : addon.getSalActions()) {
                result.add(proto.getUri());
            }
        }
        return new ArrayList<String>(result);
    }

    @Nonnull
    private List<ConnectionHandleType> getCardHandles() {
        ConnectionHandleType handle = new ConnectionHandleType();
        Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(handle, false);
        ArrayList<ConnectionHandleType> result = new ArrayList<ConnectionHandleType>(entries.size());
        for (CardStateEntry entry : entries) {
            result.add(entry.handleCopy());
        }
        return result;
    }
}

