/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.status;

import java.util.List;
import java.util.Map;
import org.openecard.addon.Context;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Headers;
import org.openecard.addon.bind.RequestBody;
import org.openecard.addons.status.StatusHandler;
import org.openecard.addons.status.StatusRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusAction
implements AppPluginAction {
    private static final Logger LOG = LoggerFactory.getLogger(StatusAction.class);
    private StatusHandler statusHandler;

    @Override
    public void init(Context ctx) {
        this.statusHandler = new StatusHandler(ctx);
    }

    @Override
    public void destroy() {
        this.statusHandler = null;
    }

    @Override
    public BindingResult execute(RequestBody body, Map<String, String> parameters, Headers headers, List<Attachment> attachments) {
        BindingResult response;
        try {
            StatusRequest statusRequest = StatusRequest.convert(parameters);
            response = this.statusHandler.handleRequest(statusRequest);
        }
        catch (Exception e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            LOG.error(e.getMessage(), e);
        }
        return response;
    }
}

