/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.utils.LocalizedStringExtractor;

@XmlRootElement(name="ProtocolPluginSpecification")
@XmlType(propOrder={"uri", "className", "loadOnStartup", "localizedName", "localizedDescription", "configDescription"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProtocolPluginSpecification {
    @XmlElement(name="ClassName")
    private String className;
    @XmlElement(name="LoadOnStartup", required=false, defaultValue="false")
    private Boolean loadOnStartup;
    @XmlElement(name="URI")
    private String uri;
    @XmlElement(name="LocalizedName")
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    @XmlElement(name="LocalizedDescription")
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    @XmlElement(name="ConfigDescription")
    private Configuration configDescription;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Boolean isLoadOnStartup() {
        if (this.loadOnStartup == null) {
            return false;
        }
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setConfigDescription(Configuration configDescription) {
        this.configDescription = configDescription;
    }

    public String getLocalizedName(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedName, languageCode);
    }

    public String getLocalizedDescription(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedDescription, languageCode);
    }
}

