/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.utils.LocalizedStringExtractor;

@XmlRootElement(name="AppExtensionSpecification")
@XmlType(propOrder={"id", "className", "loadOnStartup", "localizedName", "localizedDescription", "configDescription"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppExtensionSpecification {
    @XmlElement(name="ID", required=true)
    private String id;
    @XmlElement(name="ClassName", required=true)
    private String className;
    @XmlElement(name="LoadOnStartup", required=false, defaultValue="false")
    private Boolean loadOnStartup;
    @XmlElement(name="LocalizedName", required=false)
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    @XmlElement(name="LocalizedDescription", required=false)
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    @XmlElement(name="ConfigDescription", required=true)
    private Configuration configDescription;

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Boolean isLoadOnStartup() {
        if (this.loadOnStartup == null) {
            return false;
        }
        return this.loadOnStartup;
    }

    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setConfigDescription(Configuration configDescription) {
        this.configDescription = configDescription;
    }

    public String getLocalizedName(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedName, languageCode);
    }

    public String getLocalizedDescription(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedDescription, languageCode);
    }
}

