/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.addon.utils.LocalizedStringExtractor;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="AddonSpecification")
@XmlType(propOrder={"id", "version", "license", "licenseText", "localizedName", "localizedDescription", "about", "logo", "configDescription", "bindingActions", "applicationActions", "ifdActions", "salActions"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AddonSpecification
implements Comparable<AddonSpecification> {
    private static final Logger logger = LoggerFactory.getLogger(AddonSpecification.class);
    @XmlElement(name="ID", required=true)
    private String id;
    @XmlElement(name="Logo", required=true)
    private String logo;
    @XmlElement(name="Version", required=true)
    private String version;
    @XmlElement(name="License", required=true)
    private String license;
    @XmlElement(name="LicenseText", required=false)
    private final List<LocalizedString> licenseText = new ArrayList<LocalizedString>();
    @XmlElement(name="ConfigDescription", required=true)
    private Configuration configDescription;
    @XmlElement(name="LocalizedName", type=LocalizedString.class, required=false)
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    @XmlElement(name="LocalizedDescription", type=LocalizedString.class, required=false)
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    @XmlElement(name="About", type=LocalizedString.class, required=false)
    private final List<LocalizedString> about = new ArrayList<LocalizedString>();
    @XmlElement(name="AppExtensionSpecification", type=AppExtensionSpecification.class, required=false)
    @XmlElementWrapper(name="ApplicationActions", required=false)
    private final ArrayList<AppExtensionSpecification> applicationActions = new ArrayList();
    @XmlElementWrapper(name="BindingActions", required=false)
    @XmlElement(name="AppPluginSpecification", type=AppPluginSpecification.class, required=false)
    private final ArrayList<AppPluginSpecification> bindingActions = new ArrayList();
    @XmlElementWrapper(name="IFDActions", required=false)
    @XmlElement(name="ProtocolPluginSpecification", type=ProtocolPluginSpecification.class, required=false)
    private final ArrayList<ProtocolPluginSpecification> ifdActions = new ArrayList();
    @XmlElementWrapper(name="SALActions", required=false)
    @XmlElement(name="ProtocolPluginSpecification", type=ProtocolPluginSpecification.class, required=false)
    private final ArrayList<ProtocolPluginSpecification> salActions = new ArrayList();

    public String getId() {
        return this.id;
    }

    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    public String getLocalizedName(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedName, languageCode);
    }

    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public String getLocalizedDescription(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedDescription, languageCode);
    }

    public String getLogo() {
        return this.logo;
    }

    public String getVersion() {
        return this.version;
    }

    public List<LocalizedString> getAbout() {
        return this.about;
    }

    public String getAbout(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.about, languageCode);
    }

    public String getLicense() {
        return this.license;
    }

    public List<LocalizedString> getLicenseText() {
        return this.licenseText;
    }

    public String getLicenseText(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.licenseText, languageCode);
    }

    public ArrayList<AppPluginSpecification> getBindingActions() {
        return this.bindingActions;
    }

    public ArrayList<ProtocolPluginSpecification> getIfdActions() {
        return this.ifdActions;
    }

    public ArrayList<AppExtensionSpecification> getApplicationActions() {
        return this.applicationActions;
    }

    public ArrayList<ProtocolPluginSpecification> getSalActions() {
        return this.salActions;
    }

    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogo(String logo) {
        this.logo = logo;
        logger.debug("LogoFile: " + logo);
    }

    public byte[] getLogoBytes() {
        if (this.logo != null && !this.logo.isEmpty()) {
            try {
                InputStream logoStream = FileUtils.resolveResourceAsStream(AddonSpecification.class, this.logo);
                return FileUtils.toByteArray(logoStream);
            }
            catch (FileNotFoundException e) {
                logger.error("Logo file couldn't be found.", e);
                return null;
            }
            catch (IOException | NullPointerException e) {
                logger.error("Logo file couldn't be read.", e);
                return null;
            }
        }
        return null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setConfigDescription(Configuration configDescriptionNew) {
        this.configDescription = configDescriptionNew;
    }

    public AppPluginSpecification searchByResourceName(@Nonnull String resourceName) {
        for (AppPluginSpecification desc : this.bindingActions) {
            for (String prefix : this.prefixResourceList(resourceName)) {
                if (!prefix.equals(desc.getResourceName())) continue;
                return desc;
            }
        }
        return null;
    }

    private List<String> prefixResourceList(String resourceName) {
        String[] parts = resourceName.split("/");
        ArrayList<String> result = new ArrayList<String>(parts.length);
        String nextResource = "";
        for (String part : parts) {
            nextResource = nextResource + part;
            result.add(nextResource);
            nextResource = nextResource + "/";
        }
        Collections.reverse(result);
        return result;
    }

    public AppExtensionSpecification searchByActionId(String id) {
        for (AppExtensionSpecification desc : this.applicationActions) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public ProtocolPluginSpecification searchIFDActionByURI(String uri) {
        for (ProtocolPluginSpecification desc : this.ifdActions) {
            if (!desc.getUri().equals(uri)) continue;
            return desc;
        }
        return null;
    }

    public ProtocolPluginSpecification searchSALActionByURI(String uri) {
        for (ProtocolPluginSpecification desc : this.salActions) {
            if (!desc.getUri().equals(uri)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public int compareTo(AddonSpecification o) {
        int versionRes = this.version.compareTo(o.getVersion());
        int idRes = this.id.compareTo(o.getId());
        if (versionRes == 0 && idRes == 0) {
            return 0;
        }
        if (versionRes == 0) {
            if (idRes > 0) {
                return 1;
            }
            if (idRes < 0) {
                return -1;
            }
            return -2;
        }
        if (idRes == 0) {
            if (versionRes > 0) {
                return 1;
            }
            if (versionRes < 0) {
                return -1;
            }
            return -2;
        }
        if (idRes > 0) {
            return 1;
        }
        if (idRes < 0) {
            return -1;
        }
        return -2;
    }

    public int hashCode() {
        int versionHash = this.version.hashCode();
        int idHash = this.id.hashCode();
        return versionHash + idHash;
    }

    public boolean equals(Object addonSpec) {
        if (addonSpec instanceof AddonSpecification) {
            return this.compareTo((AddonSpecification)addonSpec) == 0;
        }
        return false;
    }
}

