/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.bind;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.openecard.addon.bind.Body;
import org.openecard.common.util.StringUtils;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBody
extends Body {
    private static final Logger LOG = LoggerFactory.getLogger(RequestBody.class);
    private final String path;

    public RequestBody(String path) throws WSMarshallerException {
        this.path = path;
    }

    public RequestBody(String path, WSMarshaller m) {
        super(m);
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getFormParamValue() {
        String[] entries;
        HashMap<String, String> result = new HashMap<String, String>();
        String value = StringUtils.nullToEmpty(this.getValue()).trim();
        for (String entry : entries = value.split("&")) {
            String[] split = entry.split("=");
            try {
                String key;
                if (split.length == 1) {
                    key = URLDecoder.decode(split[0], "UTF-8");
                    result.put(key, null);
                    continue;
                }
                if (split.length != 2) continue;
                key = URLDecoder.decode(split[0], "UTF-8");
                String val = URLDecoder.decode(split[1], "UTF-8");
                result.put(key, val);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Default encoding is not supported by this JVM.", ex);
            }
        }
        return result;
    }
}

