/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.bind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.addon.bind.HeaderEntry;

public class Headers {
    private final LinkedHashMap<String, Deque<HeaderEntry>> headers = new LinkedHashMap();

    public void addHeader(@Nonnull String name, @Nonnull String value) {
        this.addHeader(new HeaderEntry(name, value));
    }

    public void addHeader(@Nonnull HeaderEntry h) {
        this.getHeaders(h.getName()).add(h);
    }

    public void setHeader(@Nonnull String name, @Nonnull String value) {
        this.setHeader(new HeaderEntry(name, value));
    }

    public void setHeader(@Nonnull HeaderEntry h) {
        Deque<HeaderEntry> hs = this.getHeaders(h.getName());
        hs.clear();
        hs.add(h);
    }

    public void removeHeader(@Nonnull String name) {
        this.getHeaders(name).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Deque<HeaderEntry> getHeaders(@Nonnull String name) {
        Deque<HeaderEntry> sameHeaders;
        LinkedHashMap<String, Deque<HeaderEntry>> linkedHashMap = this.headers;
        synchronized (linkedHashMap) {
            sameHeaders = this.headers.get(name);
            if (sameHeaders == null) {
                sameHeaders = new ConcurrentLinkedDeque<HeaderEntry>();
                this.headers.put(name, sameHeaders);
            }
        }
        return sameHeaders;
    }

    @Nullable
    public HeaderEntry getFirstHeader(@Nonnull String name) {
        return this.getHeaders(name).peekFirst();
    }

    @Nonnull
    public Deque<String> getHeaderValues(@Nonnull String name) {
        LinkedList<String> result = new LinkedList<String>();
        for (HeaderEntry next : this.getHeaders(name)) {
            result.add(next.getValue());
        }
        return result;
    }

    @Nonnull
    public Collection<String> getHeaderNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Deque<HeaderEntry>> next : this.headers.entrySet()) {
            if (next.getValue().isEmpty()) continue;
            result.add(next.getKey());
        }
        return result;
    }
}

