/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.bind;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.TransformerException;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Body {
    private static final Logger logger = LoggerFactory.getLogger(Body.class);
    private String value;
    private String mimeType;
    private boolean base64Encoded;
    private WSMarshaller m;

    protected Body() throws WSMarshallerException {
        this(Body.loadEmptyMarshaller());
    }

    protected Body(@Nullable WSMarshaller m) {
        this(null, null, false, m);
    }

    protected Body(@Nullable String value, @Nullable String mimeType, boolean base64Encoded) throws WSMarshallerException {
        this(value, mimeType, base64Encoded, Body.loadEmptyMarshaller());
    }

    protected Body(@Nullable String value, @Nullable String mimeType, boolean base64Encoded, @Nullable WSMarshaller m) {
        this.value = value;
        this.mimeType = mimeType;
        this.base64Encoded = base64Encoded;
        this.m = m;
    }

    private static WSMarshaller loadEmptyMarshaller() throws WSMarshallerException {
        WSMarshaller m = WSMarshallerFactory.createInstance();
        m.removeAllTypeClasses();
        return m;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isBase64() {
        return this.base64Encoded;
    }

    @Nullable
    protected WSMarshaller getMarshaller() {
        return this.m;
    }

    public void setValue(@Nullable String value, @Nullable String mimeType, boolean base64Encoded) {
        if (value == null) {
            mimeType = null;
        } else if (mimeType == null || "".equals(mimeType)) {
            logger.warn("No MIME type specified, falling back to 'text/plain'.");
            mimeType = "text/plain";
        }
        if (value == null) {
            base64Encoded = false;
        }
        this.value = value;
        this.mimeType = mimeType;
        this.base64Encoded = base64Encoded;
    }

    public void setValue(@Nullable String value) {
        this.setValue(value, "text/plain");
    }

    public void setValue(@Nullable String value, @Nullable String mimeType) {
        this.setValue(value, mimeType, false);
    }

    public void setValue(@Nonnull byte[] value, @Nullable String mimeType) {
        if (value == null) {
            throw new NullPointerException("The supplied value is null.");
        }
        String encVal = DatatypeConverter.printBase64Binary((byte[])value);
        this.setValue(encVal, mimeType, true);
    }

    public void setValue(@Nonnull Node domNode) throws TransformerException {
        this.setValue(domNode, null);
    }

    public void setValue(@Nonnull Node domNode, @Nullable String mimeType) throws TransformerException {
        String nodeVal = this.getMarshaller().doc2str(domNode);
        if (mimeType == null || "".equals(mimeType)) {
            this.setValue(nodeVal, "application/xml");
        } else {
            this.setValue(nodeVal, mimeType);
        }
    }

    public void setJAXBObjectValue(@Nonnull Object jaxbObj) throws MarshallingTypeException, TransformerException {
        this.setJAXBObjectValue(jaxbObj, null);
    }

    public void setJAXBObjectValue(@Nonnull Object jaxbObj, @Nullable String mimeType) throws MarshallingTypeException, TransformerException {
        Document nodeVal = this.getMarshaller().marshal(jaxbObj);
        this.setValue(nodeVal, mimeType);
    }
}

