/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.bind;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.ResponseBody;

public class BindingResult {
    private BindingResultCode resultCode;
    private ResponseBody body;
    private String resultMessage;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, String> auxData = new HashMap<String, String>();
    private final List<Attachment> attachments = new ArrayList<Attachment>(10);

    public BindingResult() {
        this.resultCode = BindingResultCode.OK;
    }

    public BindingResult(@Nonnull BindingResultCode resultCode) {
        if (resultCode == null) {
            throw new IllegalArgumentException("No result code given in constructor invocation.");
        }
        this.resultCode = resultCode;
    }

    public BindingResult setResultCode(@Nonnull BindingResultCode resultCode) {
        if (resultCode == null) {
            throw new IllegalArgumentException("No result code given in constructor invocation.");
        }
        this.resultCode = resultCode;
        return this;
    }

    @Nonnull
    public BindingResultCode getResultCode() {
        return this.resultCode;
    }

    public BindingResult setBody(@Nullable ResponseBody body) {
        this.body = body;
        return this;
    }

    @Nullable
    public ResponseBody getBody() {
        return this.body;
    }

    @Nonnull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public BindingResult addParameter(@Nonnull String key, @Nullable String value) {
        this.parameters.put(key, value);
        return this;
    }

    public BindingResult addParameters(@Nonnull Map<String, String> parameters) {
        this.parameters.putAll(parameters);
        return this;
    }

    @Nullable
    public String removeParameter(@Nonnull String key) {
        return this.parameters.remove(key);
    }

    @Nonnull
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Nonnull
    public Map<String, String> getAuxResultData() {
        return this.auxData;
    }

    public BindingResult addAuxResultData(@Nonnull String key, @Nullable String value) {
        this.auxData.put(key, value);
        return this;
    }

    public BindingResult setResultMessage(@Nullable String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    @Nullable
    public String getResultMessage() {
        return this.resultMessage;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        w.write("BindingResult <");
        w.write(this.getResultCode().name());
        w.write(", ");
        w.write(this.getResultMessage() == null ? "" : "'");
        w.write(this.getResultMessage());
        w.write(this.getResultMessage() == null ? "" : "'");
        w.write(">\n");
        Map<String, String> params = this.getParameters();
        this.printMap(w, "  ", "Parameters", params);
        Map<String, String> aux = this.getAuxResultData();
        this.printMap(w, "  ", "AuxResultData", aux);
        ResponseBody b = this.getBody();
        if (b != null) {
            w.append("  Body type: ").append(this.body.getMimeType()).append("\n");
        }
        List<Attachment> atts = this.getAttachments();
        for (Attachment a : atts) {
            w.append("  Attachment with type: ").append(a.getMIMEType()).append("\n");
        }
        return w.toString();
    }

    private <V> void printMap(StringWriter w, String prefix, String identifier, Map<String, V> map) {
        if (!map.isEmpty()) {
            w.append(prefix).append(identifier).append(" {\n");
            for (Map.Entry<String, V> next : map.entrySet()) {
                w.append(prefix).append(prefix).append("'").append(next.getKey()).append("': ");
                V v = next.getValue();
                if (v instanceof String) {
                    w.append("'").append(v.toString()).append("',\n");
                    continue;
                }
                String s = v == null ? "null" : v.toString();
                w.append(s).append(",\n");
            }
            w.append(prefix).append("}\n");
        }
    }
}

