/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.openecard.addon.AddonException;
import org.openecard.addon.AddonFileSystemMonitor;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.JARFileFilter;
import org.openecard.addon.ManifestExtractor;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRegistry
implements AddonRegistry {
    private static final Logger logger = LoggerFactory.getLogger(FileRegistry.class.getName());
    private static final HashMap<String, AddonSpecification> registeredAddons = new HashMap();
    private static final HashMap<String, File> files = new HashMap();
    private final AddonManager manager;
    private final Future<Void> initComplete;
    private AddonFileSystemMonitor fsMonitor;

    public FileRegistry(AddonManager manager) {
        FutureTask<Void> initCompleteTmp;
        this.manager = manager;
        try {
            initCompleteTmp = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FileRegistry.this.loadExistingAddons();
                    FileRegistry.this.startFileMonitor();
                    return null;
                }
            });
            new Thread(initCompleteTmp, "Init-File-Addons").start();
        }
        catch (SecurityException e) {
            String msg = "Failed to access add-on directory due to missing privileges. FileRegistry not working.";
            logger.error(msg, e);
            initCompleteTmp = this.getCompletedFuture();
        }
        this.initComplete = initCompleteTmp;
    }

    private FutureTask<Void> getCompletedFuture() {
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
        f.run();
        return f;
    }

    private void blockUntilInit() {
        try {
            this.initComplete.get();
        }
        catch (InterruptedException ex) {
            String msg = "Initialization of the file based Add-ons has been interrupted.";
            logger.warn(msg);
            throw new RuntimeException(msg);
        }
        catch (ExecutionException ex) {
            String msg = "Initialization of the file based Add-ons yielded an error.";
            logger.error(msg, ex);
            throw new RuntimeException(msg, ex.getCause());
        }
    }

    private HashMap<String, AddonSpecification> getAddons() {
        this.blockUntilInit();
        return registeredAddons;
    }

    private HashMap<String, File> getFiles() {
        this.blockUntilInit();
        return files;
    }

    private void startFileMonitor() {
        try {
            File addonPath = FileUtils.getAddonsDir();
            logger.debug("Starting addon filesystem monitor on path: {}", (Object)addonPath.getPath());
            this.fsMonitor = new AddonFileSystemMonitor(this, this.manager);
            this.fsMonitor.start();
        }
        catch (SecurityException ex) {
            logger.error("SecurityException seems like you don't have permissions to access the addons directory.", ex);
        }
        catch (IOException ex) {
            logger.warn("Failed to start file watcher on addon directory.");
        }
    }

    public void register(AddonSpecification desc, File file) {
        registeredAddons.put(file.getName(), desc);
        files.put(desc.getId(), file);
    }

    public void unregister(File file) {
        Set<Map.Entry<String, File>> entrySet = this.getFiles().entrySet();
        for (Map.Entry<String, File> next : entrySet) {
            if (!next.getValue().equals(file)) continue;
            String id = next.getKey();
            registeredAddons.remove(file.getName());
            files.remove(id);
            logger.debug("Successfully removed addon {}", (Object)file.getName());
            break;
        }
    }

    @Override
    public Set<AddonSpecification> listAddons() {
        HashSet<AddonSpecification> list = new HashSet<AddonSpecification>();
        list.addAll(this.getAddons().values());
        return list;
    }

    @Override
    public AddonSpecification search(String id) {
        for (AddonSpecification desc : this.getAddons().values()) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public Set<AddonSpecification> searchByName(String name) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons().values()) {
            for (LocalizedString s : desc.getLocalizedName()) {
                if (!s.getValue().equals(name)) continue;
                matchingAddons.add(desc);
            }
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchIFDProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons().values()) {
            ProtocolPluginSpecification protocolDesc = desc.searchIFDActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchSALProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons().values()) {
            ProtocolPluginSpecification protocolDesc = desc.searchSALActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public ClassLoader downloadAddon(AddonSpecification addonSpec) throws AddonException {
        String aId = addonSpec.getId();
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            URL[] url = new URL[]{files.get(aId).toURI().toURL()};
            URLClassLoader ucl = new URLClassLoader(url, cl);
            return ucl;
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), e);
            throw new AddonException("Failed to convert Add-on location URI to URL.");
        }
    }

    @Override
    public Set<AddonSpecification> searchByResourceName(String resourceName) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons().values()) {
            AppPluginSpecification actionDesc = desc.searchByResourceName(resourceName);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchByActionId(String actionId) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons().values()) {
            AppExtensionSpecification actionDesc = desc.searchByActionId(actionId);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    private void loadExistingAddons() throws WSMarshallerException {
        try {
            File addonsDir = FileUtils.getAddonsDir();
            File[] addons = addonsDir.listFiles(new JARFileFilter());
            addons = addons == null ? new File[]{} : addons;
            ManifestExtractor mEx = new ManifestExtractor();
            for (File addon : addons) {
                AddonSpecification addonSpec = mEx.getAddonSpecificationFromFile(addon);
                if (addonSpec == null) continue;
                this.register(addonSpec, addon);
                logger.info("Loaded external addon {}", (Object)addon.getName());
            }
        }
        catch (IOException ex) {
            logger.error("Failed to load addons directory.", ex);
        }
        catch (SecurityException ex) {
            logger.error("SecurityException seems like you don't have permissions to access the addons directory.", ex);
        }
    }

    @Override
    public Set<AddonSpecification> listInstalledAddons() {
        return this.listAddons();
    }

    protected AddonSpecification getAddonSpecByFileName(String fileName) {
        return this.getAddons().get(fileName);
    }

    protected void uninstallAddon(AddonSpecification addonSpec) {
        File addonJar = files.get(addonSpec.getId());
        addonJar.delete();
    }
}

