/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.AddonException;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.Cache;
import org.openecard.addon.CombiningRegistry;
import org.openecard.addon.Context;
import org.openecard.addon.EventHandler;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.bind.AppExtensionActionProxy;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.AppPluginActionProxy;
import org.openecard.addon.ifd.IFDProtocol;
import org.openecard.addon.ifd.IFDProtocolProxy;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.addon.sal.SALProtocol;
import org.openecard.addon.sal.SALProtocolProxy;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.util.FacadeInvocationHandler;
import org.openecard.gui.UserConsent;
import org.openecard.gui.definition.ViewController;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonManager {
    private static final Logger LOG = LoggerFactory.getLogger(AddonManager.class);
    private final CombiningRegistry registry;
    private final AddonRegistry protectedRegistry;
    private final Environment env;
    private final UserConsent userConsent;
    private final CardStateMap cardStates;
    private final EventHandler eventHandler;
    private final ViewController viewController;
    private final TreeMap<AddonSpecification, TreeMap<String, IFDProtocol>> ifdProtocolCache = new TreeMap();
    private final TreeMap<AddonSpecification, TreeMap<String, SALProtocol>> salProtocolCache = new TreeMap();
    private final TreeMap<AddonSpecification, TreeMap<String, AppExtensionAction>> appExtActionCache = new TreeMap();
    private final TreeMap<AddonSpecification, TreeMap<String, AppPluginAction>> appPluginActionCache = new TreeMap();
    private final Cache cache = new Cache();

    public AddonManager(Environment env, UserConsent userConsent, CardStateMap cardStates, ViewController view) throws WSMarshallerException {
        this.registry = new CombiningRegistry(this);
        this.protectedRegistry = AddonManager.getProtectedRegistry(this.registry);
        this.env = env;
        this.userConsent = userConsent;
        this.cardStates = cardStates;
        this.eventHandler = new EventHandler();
        this.env.getEventDispatcher().add(this.eventHandler);
        this.viewController = view;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AddonManager.this.loadLoadOnStartAddons();
            }
        }, "Init-Addons").start();
    }

    private void loadLoadOnStartAddons() {
        Set<AddonSpecification> specs = this.protectedRegistry.listAddons();
        for (AddonSpecification addonSpec : specs) {
            this.loadLoadOnStartupActions(addonSpec);
        }
    }

    protected void loadLoadOnStartupActions(AddonSpecification addonSpec) {
        if (!addonSpec.getApplicationActions().isEmpty()) {
            for (AppExtensionSpecification appExSpec : addonSpec.getApplicationActions()) {
                if (!appExSpec.isLoadOnStartup().booleanValue()) continue;
                this.getAppExtensionAction(addonSpec, appExSpec.getId());
            }
        }
        if (!addonSpec.getBindingActions().isEmpty()) {
            for (AppPluginSpecification appPlugSpec : addonSpec.getBindingActions()) {
                if (!appPlugSpec.isLoadOnStartup().booleanValue()) continue;
                this.getAppPluginAction(addonSpec, appPlugSpec.getResourceName());
            }
        }
        if (!addonSpec.getIfdActions().isEmpty()) {
            for (ProtocolPluginSpecification protPlugSpec : addonSpec.getIfdActions()) {
                if (!protPlugSpec.isLoadOnStartup().booleanValue()) continue;
                this.getIFDProtocol(addonSpec, protPlugSpec.getUri());
            }
        }
        if (!addonSpec.getSalActions().isEmpty()) {
            for (ProtocolPluginSpecification protPlugSpec : addonSpec.getSalActions()) {
                if (!protPlugSpec.isLoadOnStartup().booleanValue()) continue;
                this.getSALProtocol(addonSpec, protPlugSpec.getUri());
            }
        }
    }

    private void unloadAllAddons() {
        Set<AddonSpecification> addons = this.protectedRegistry.listInstalledAddons();
        for (AddonSpecification addonSpec : addons) {
            this.unloadAddon(addonSpec);
        }
    }

    protected void unloadAddon(AddonSpecification addonSpec) {
        Collection<Object> actionsAndProtocols = this.cache.getAllAddonData(addonSpec);
        for (Object obj : actionsAndProtocols) {
            if (obj instanceof IFDProtocol) {
                ((IFDProtocol)obj).destroy();
                continue;
            }
            if (obj instanceof SALProtocol) {
                ((SALProtocol)obj).destroy();
                continue;
            }
            if (obj instanceof AppExtensionAction) {
                ((AppExtensionAction)obj).destroy();
                continue;
            }
            if (obj instanceof AppPluginAction) {
                ((AppPluginAction)obj).destroy();
                continue;
            }
            LOG.warn("The cache contains invalid objects.");
        }
        this.cache.removeCompleteAddonCache(addonSpec);
    }

    private static AddonRegistry getProtectedRegistry(AddonRegistry registry) {
        ClassLoader cl = AddonManager.class.getClassLoader();
        Class[] interfaces = new Class[]{AddonRegistry.class};
        FacadeInvocationHandler handler = new FacadeInvocationHandler(registry);
        Object o = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)handler);
        return (AddonRegistry)o;
    }

    public AddonRegistry getRegistry() {
        return this.protectedRegistry;
    }

    public AddonRegistry getBuiltinRegistry() {
        return AddonManager.getProtectedRegistry(this.registry.getClasspathRegistry());
    }

    public AddonRegistry getExternalRegistry() {
        return AddonManager.getProtectedRegistry(this.registry.getFileRegistry());
    }

    public void registerClasspathAddon(AddonSpecification desc) {
        this.registry.getClasspathRegistry().register(desc);
    }

    public IFDProtocol getIFDProtocol(@Nonnull AddonSpecification addonSpec, @Nonnull String uri) {
        IFDProtocol ifdProt = this.cache.getIFDProtocol(addonSpec, uri);
        ProtocolPluginSpecification protoSpec = addonSpec.searchIFDActionByURI(uri);
        if (protoSpec == null) {
            LOG.error("Requested IFD Protocol {} does not exist in Add-on {}.", (Object)uri, (Object)addonSpec.getId());
        } else {
            String className = protoSpec.getClassName();
            try {
                ClassLoader cl = this.registry.downloadAddon(addonSpec);
                IFDProtocolProxy protoFactory = new IFDProtocolProxy(className, cl);
                Context aCtx = this.createContext(addonSpec);
                protoFactory.init(aCtx);
                this.cache.addIFDProtocol(addonSpec, uri, protoFactory);
                return protoFactory;
            }
            catch (ActionInitializationException e) {
                LOG.error("Initialization of IFD Protocol failed", e);
            }
            catch (AddonException ex) {
                LOG.error("Failed to download Add-on.", ex);
            }
        }
        return null;
    }

    public SALProtocol getSALProtocol(@Nonnull AddonSpecification addonSpec, @Nonnull String uri) {
        SALProtocol salProt = this.cache.getSALProtocol(addonSpec, uri);
        ProtocolPluginSpecification protoSpec = addonSpec.searchSALActionByURI(uri);
        if (protoSpec == null) {
            LOG.error("Requested SAL Protocol {} does not exist in Add-on {}.", (Object)uri, (Object)addonSpec.getId());
        } else {
            String className = protoSpec.getClassName();
            try {
                ClassLoader cl = this.registry.downloadAddon(addonSpec);
                SALProtocolProxy protoFactory = new SALProtocolProxy(className, cl);
                Context aCtx = this.createContext(addonSpec);
                protoFactory.init(aCtx);
                this.cache.addSALProtocol(addonSpec, uri, protoFactory);
                return protoFactory;
            }
            catch (ActionInitializationException e) {
                LOG.error("Initialization of SAL Protocol failed", e);
            }
            catch (AddonException ex) {
                LOG.error("Failed to download Add-on.", ex);
            }
        }
        return null;
    }

    public AppExtensionAction getAppExtensionAction(@Nonnull AddonSpecification addonSpec, @Nonnull String actionId) {
        AppExtensionAction appExtAction = this.cache.getAppExtensionAction(addonSpec, actionId);
        if (appExtAction != null) {
            return appExtAction;
        }
        AppExtensionSpecification protoSpec = addonSpec.searchByActionId(actionId);
        if (protoSpec == null) {
            LOG.error("Requested Extension {} does not exist in Add-on {}.", (Object)actionId, (Object)addonSpec.getId());
        } else {
            String className = protoSpec.getClassName();
            try {
                ClassLoader cl = this.registry.downloadAddon(addonSpec);
                AppExtensionActionProxy protoFactory = new AppExtensionActionProxy(className, cl);
                Context aCtx = this.createContext(addonSpec);
                protoFactory.init(aCtx);
                this.cache.addAppExtensionAction(addonSpec, actionId, protoFactory);
                return protoFactory;
            }
            catch (ActionInitializationException e) {
                LOG.error("Initialization of AppExtensionAction failed", e);
            }
            catch (AddonException ex) {
                LOG.error("Failed to download Add-on.", ex);
            }
        }
        return null;
    }

    public AppPluginAction getAppPluginAction(@Nonnull AddonSpecification addonSpec, @Nonnull String resourceName) {
        AppPluginAction appPluginAction = this.cache.getAppPluginAction(addonSpec, resourceName);
        if (appPluginAction != null) {
            return appPluginAction;
        }
        AppPluginSpecification protoSpec = addonSpec.searchByResourceName(resourceName);
        if (protoSpec == null) {
            LOG.error("Plugin for resource {} does not exist in Add-on {}.", (Object)resourceName, (Object)addonSpec.getId());
        } else {
            String className = protoSpec.getClassName();
            try {
                ClassLoader cl = this.registry.downloadAddon(addonSpec);
                AppPluginActionProxy protoFactory = new AppPluginActionProxy(className, cl);
                Context aCtx = this.createContext(addonSpec);
                protoFactory.init(aCtx);
                this.cache.addAppPluginAction(addonSpec, resourceName, protoFactory);
                return protoFactory;
            }
            catch (ActionInitializationException e) {
                LOG.error("Initialization of AppPluginAction failed", e);
            }
            catch (AddonException ex) {
                LOG.error("Failed to download Add-on.", ex);
            }
        }
        return null;
    }

    private Context createContext(@Nonnull AddonSpecification addonSpec) {
        Context aCtx = new Context(this, this.env.getDispatcher(), this.env.getEventDispatcher(), addonSpec, this.viewController);
        aCtx.setCardRecognition(this.env.getRecognition());
        aCtx.setCardStateMap(this.cardStates);
        aCtx.setEventHandle(this.eventHandler);
        aCtx.setUserConsent(this.userConsent);
        return aCtx;
    }

    public void shutdown() {
        this.unloadAllAddons();
    }

    public void uninstallAddon(@Nonnull AddonSpecification addonSpec) {
        this.registry.getFileRegistry().uninstallAddon(addonSpec);
    }
}

