/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Set;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonProperties;
import org.openecard.addon.FileRegistry;
import org.openecard.addon.JARFileFilter;
import org.openecard.addon.ManifestExtractor;
import org.openecard.addon.MultipleAddonRegistration;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonFileSystemMonitor {
    private static final Logger logger = LoggerFactory.getLogger(AddonFileSystemMonitor.class.getName());
    private final FileRegistry fileRegistry;
    private final AddonManager manager;
    private final Path addonDir;
    private WatchService ws;
    private Thread t;

    public AddonFileSystemMonitor(FileRegistry fileRegistry, AddonManager manager) throws IOException, SecurityException {
        this.fileRegistry = fileRegistry;
        this.manager = manager;
        this.addonDir = FileUtils.getAddonsDir().toPath();
    }

    public void start() throws IOException, SecurityException {
        if (this.t != null) {
            String msg = "Trying to start already running file watcher.";
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        FileSystem fs = FileSystems.getDefault();
        this.ws = fs.newWatchService();
        this.addonDir.register(this.ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.t = new Thread((Runnable)new Runner(), "Addon-File-Watcher");
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stop() {
        if (this.t == null) {
            String msg = "Trying to stop idling file watcher.";
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        try {
            this.ws.close();
            this.t.join(1000L);
            if (this.t.isAlive()) {
                this.t.interrupt();
            }
        }
        catch (IOException ex) {
            logger.error("Failed to close file watcher, trying to close by force.");
            this.t.interrupt();
        }
        catch (InterruptedException ex) {
            logger.error("File watcher failed to terminate in time, killing it forcedly.");
            this.t.interrupt();
        }
    }

    private void addAddon(Path file) throws WSMarshallerException {
        logger.info("Trying to register addon {}.", (Object)file.getFileName());
        String fName = file.toFile().getName();
        try {
            AddonSpecification spec = this.extractSpec(file);
            if (spec != null) {
                this.fileRegistry.register(spec, file.toFile());
                this.manager.loadLoadOnStartupActions(spec);
                logger.info("Successfully registered {} as addon.", (Object)fName);
            } else {
                logger.error("The jar file {} does not seem to be an add-on.", (Object)fName);
            }
        }
        catch (MultipleAddonRegistration ex) {
            logger.error("The jar file {} is an already registered add-on.", (Object)fName);
        }
    }

    private void removeAddon(Path file) {
        logger.info("Trying to remove addon {}.", (Object)file.getFileName());
        AddonSpecification spec = this.getCurrentSpec(file);
        if (spec != null) {
            this.manager.unloadAddon(spec);
            AddonProperties addonProps = new AddonProperties(spec);
            addonProps.removeConfiguration();
            this.fileRegistry.unregister(file.toFile());
            logger.info("Succesfully removed add-on {}.", (Object)file.toFile().getName());
        }
    }

    private void replaceAddon(Path file) throws WSMarshallerException {
        try {
            AddonSpecification spec = this.extractSpec(file);
            if (spec != null) {
                this.removeAddon(file);
                this.addAddon(file);
            }
        }
        catch (MultipleAddonRegistration ex) {
            String fName = file.toFile().getName();
            logger.error("The jar file {} is an already registered add-on.", (Object)fName);
        }
    }

    private AddonSpecification extractSpec(Path file) throws WSMarshallerException, MultipleAddonRegistration {
        ManifestExtractor mfEx;
        AddonSpecification spec;
        if (this.isJarFile(file, true) && (spec = (mfEx = new ManifestExtractor()).getAddonSpecificationFromFile(file.toFile())) != null) {
            Set<AddonSpecification> plugins = this.fileRegistry.listAddons();
            for (AddonSpecification desc : plugins) {
                if (!desc.getId().equals(spec.getId())) continue;
                String msg = String.format("The addon with id %s is already registered.", desc.getId());
                logger.debug("Addon '{}' is already registered by another bundle.", (Object)file.toFile().getName());
                throw new MultipleAddonRegistration(msg, spec);
            }
            return spec;
        }
        return null;
    }

    private AddonSpecification getCurrentSpec(Path file) {
        if (this.isJarFile(file, false)) {
            AddonSpecification spec = this.fileRegistry.getAddonSpecByFileName(file.toFile().getName());
            return spec;
        }
        return null;
    }

    private boolean isJarFile(Path path, boolean testType) {
        File file = path.toFile();
        boolean result = new JARFileFilter().accept(file);
        if (testType) {
            result = result && file.isFile();
        }
        return result;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    WatchKey wk = AddonFileSystemMonitor.this.ws.take();
                    for (WatchEvent<?> evt : wk.pollEvents()) {
                        Object ctx = evt.context();
                        if (!(ctx instanceof Path)) continue;
                        Path p = (Path)ctx;
                        p = AddonFileSystemMonitor.this.addonDir.resolve(p);
                        String evtName = evt.kind().name();
                        logger.debug("Hit file watcher event {}.", (Object)evtName);
                        if (StandardWatchEventKinds.ENTRY_CREATE.name().equals(evtName)) {
                            AddonFileSystemMonitor.this.addAddon(p);
                            continue;
                        }
                        if (StandardWatchEventKinds.ENTRY_DELETE.name().equals(evtName)) {
                            AddonFileSystemMonitor.this.removeAddon(p);
                            continue;
                        }
                        if (!StandardWatchEventKinds.ENTRY_MODIFY.name().equals(evtName)) continue;
                        AddonFileSystemMonitor.this.replaceAddon(p);
                    }
                    wk.reset();
                }
            }
            catch (WSMarshallerException ex) {
                logger.error("Failed to deserialize Addon manifest, Terminating file monitor.");
            }
            catch (InterruptedException | ClosedWatchServiceException ex) {
                logger.info("Watch service closed while waiting for changes.");
            }
        }
    }
}

