/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.marshal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

public abstract class WSClassLoader {
    private static final ClassLoader inst = WSClassLoader.class.getClassLoader();
    protected static final Map<String, String> serviceClasses = new HashMap<String, String>();
    protected static final Map<String, String> servicePorts = new HashMap<String, String>();

    private static Class<Service> loadClass(String serviceName) throws ClassNotFoundException {
        String className = serviceClasses.get(serviceName);
        ClassLoader cl = WSClassLoader.class.getClassLoader();
        return cl.loadClass(className);
    }

    private static WebServiceClient getClientAnnotation(Class<Service> clazz) {
        return clazz.getAnnotation(WebServiceClient.class);
    }

    private static URL getWSDL() {
        URL url = WSClassLoader.class.getResource("/ALL.wsdl");
        if (url == null) {
            url = WSClassLoader.class.getResource("ALL.wsdl");
        }
        return url;
    }

    @Nonnull
    public static Set<String> getSupportedServices() {
        TreeSet<String> s = new TreeSet<String>(serviceClasses.keySet());
        Iterator<String> it = s.iterator();
        while (it.hasNext()) {
            String nextService = it.next();
            try {
                Class<Service> clazz = WSClassLoader.loadClass(nextService);
            }
            catch (ClassNotFoundException ex) {
                it.remove();
            }
        }
        return s;
    }

    public static Object getClientService(@Nonnull String serviceName) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<Service> loaderClass = WSClassLoader.loadClass(serviceName);
        WebServiceClient clientAnnotation = WSClassLoader.getClientAnnotation(loaderClass);
        Constructor<Service> constructor = loaderClass.getConstructor(URL.class, QName.class);
        QName serviceQname = new QName(clientAnnotation.targetNamespace(), clientAnnotation.name());
        Service serviceLoaderInst = constructor.newInstance(WSClassLoader.getWSDL(), serviceQname);
        String portName = servicePorts.get(serviceName);
        Method portMethod = serviceLoaderInst.getClass().getMethod("get" + portName, WebServiceFeature[].class);
        Object serviceInst = portMethod.invoke((Object)serviceLoaderInst, new Object[]{new WebServiceFeature[0]});
        return serviceInst;
    }

    public static Object getClientService(@Nonnull String serviceName, @Nonnull String schema, @Nonnull String host, @Nonnull String port, @Nonnull String resource) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String address = schema + "://" + host + ":" + port + resource;
        Object serviceInst = WSClassLoader.getClientService(serviceName, address);
        return serviceInst;
    }

    public static Object getClientService(String serviceName, String address) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object serviceInst = WSClassLoader.getClientService(serviceName);
        BindingProvider bp = (BindingProvider)serviceInst;
        Map context = bp.getRequestContext();
        context.put("javax.xml.ws.service.endpoint.address", address);
        return serviceInst;
    }

    static {
        serviceClasses.put("SAL", "org.openecard.ws.SAL_Service");
        servicePorts.put("SAL", "SALPort");
        serviceClasses.put("Publish", "org.openecard.ws.Publish_Service");
        servicePorts.put("Publish", "Publish");
        serviceClasses.put("Subscribe", "org.openecard.ws.Subscribe_Service");
        servicePorts.put("Subscribe", "Subscribe");
        serviceClasses.put("ISO24727-Protocols", "org.openecard.ws.ISO24727Protocols_Service");
        servicePorts.put("ISO24727-Protocols", "ISO24727ProtocolsPort");
        serviceClasses.put("IFD", "org.openecard.ws.IFD_Service");
        servicePorts.put("IFD", "IFDPort");
        serviceClasses.put("IFDCallback", "org.openecard.ws.IFDCallback_Service");
        servicePorts.put("IFDCallback", "IFDCallbackPort");
        serviceClasses.put("GetCardInfoOrACD", "org.openecard.ws.GetCardInfoOrACD_Service");
        servicePorts.put("GetCardInfoOrACD", "GetCardInfoOrACD");
        serviceClasses.put("GetRecognitionTree", "org.openecard.ws.GetRecognitionTree_Service");
        servicePorts.put("GetRecognitionTree", "GetRecognitionTree");
        serviceClasses.put("Management", "org.openecard.ws.Management_Service");
        servicePorts.put("Management", "ManagementPort");
        serviceClasses.put("UpdateService", "org.openecard.ws.UpdateService_Service");
        servicePorts.put("UpdateService", "UpdateServicePort");
    }
}

