/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverridingProperties {
    private static final Logger logger = LoggerFactory.getLogger(OverridingProperties.class);
    private final Properties properties;

    public OverridingProperties(String fName) throws IOException {
        this(OverridingProperties.getfileStream(OverridingProperties.class, fName));
    }

    public OverridingProperties(Class clazz, String fName) throws IOException {
        this(OverridingProperties.getfileStream(clazz, fName));
    }

    public OverridingProperties(InputStream stream) throws IOException {
        this(stream, null);
    }

    public OverridingProperties(Properties props) throws IOException {
        this.properties = OverridingProperties.mergeWithOverrides(props);
    }

    public OverridingProperties(InputStream bundledConf, InputStream homeConf) throws IOException {
        Properties baseProps = new Properties();
        baseProps.load(bundledConf);
        bundledConf.close();
        try {
            if (homeConf != null) {
                Properties homeProps = new Properties(baseProps);
                homeProps.load(homeConf);
                homeConf.close();
                baseProps = homeProps;
            }
        }
        catch (IOException ex) {
            logger.error("Failed to load given properties stream.", ex);
        }
        this.properties = OverridingProperties.mergeWithOverrides(baseProps);
    }

    private static InputStream getfileStream(Class clazz, String fName) {
        InputStream in = clazz.getResourceAsStream("/" + fName);
        if (in == null) {
            in = clazz.getResourceAsStream(fName);
        }
        return in;
    }

    private static Properties mergeWithOverrides(Properties reference) throws IOException {
        Properties result = new Properties(reference);
        result.load(OverridingProperties.propsToStream(OverridingProperties.getOverrides(reference)));
        return result;
    }

    private static Reader propsToStream(Properties properties) throws IOException {
        StringWriter w = new StringWriter();
        properties.store(w, null);
        String propsStr = w.toString();
        return new StringReader(propsStr);
    }

    private static Properties getOverrides(Properties reference) {
        Properties overrides = new Properties();
        for (String nextKey : reference.stringPropertyNames()) {
            if (!System.getProperties().containsKey(nextKey)) continue;
            overrides.setProperty(nextKey, System.getProperties().getProperty(nextKey));
        }
        return overrides;
    }

    public final String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public final Object setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    public final Properties properties() {
        return new Properties(this.properties);
    }
}

