/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.versioncheck;

import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainLoader {
    private static final float VERSION_REFERENCE_VAL = 1.7f;

    public static void main(String[] args) {
        try {
            String msg;
            if (!MainLoader.checkJavaVersion(1.7f)) {
                String msg2 = MainLoader.getBundle().getString("MainLoader.invalid_java_version");
                String title = MainLoader.getBundle().getString("MainLoader.invalid_java_version.title");
                MainLoader.msg(title, msg2, System.getProperty("java.version"));
                System.exit(1);
            }
            Method m = null;
            try {
                String className = MainLoader.getMainClassName();
                Class<?> clazz = MainLoader.getMainClass(className);
                m = MainLoader.getMainMethod(clazz);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Main class not found.");
            }
            catch (NoSuchMethodException ex) {
                System.err.println("Main method not found.");
            }
            if (m == null) {
                String msg3 = MainLoader.getBundle().getString("MainLoader.no_method");
                String title = MainLoader.getBundle().getString("MainLoader.no_method.title");
                MainLoader.msg(title, msg3, new Object[0]);
                System.exit(1);
            }
            try {
                m.invoke(null, new Object[]{args});
            }
            catch (IllegalArgumentException ex) {
                msg = MainLoader.getBundle().getString("MainLoader.wrong_args");
                String title = MainLoader.getBundle().getString("MainLoader.wrong_args.title");
                MainLoader.msg(title, msg, new Object[0]);
                System.exit(1);
            }
            catch (IllegalAccessException ex) {
                msg = MainLoader.getBundle().getString("MainLoader.missing_rights");
                String title = MainLoader.getBundle().getString("MainLoader.missing_rights");
                MainLoader.msg(title, msg, new Object[0]);
                System.exit(1);
            }
            catch (InvocationTargetException ex) {
                msg = MainLoader.getBundle().getString("MainLoader.unhandled_error");
                String title = MainLoader.getBundle().getString("MainLoader.unhandled_error");
                MainLoader.msg(title, msg, new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            String msg = "An unhandled error occured.\n\n";
            msg = msg + ex.getClass().getName() + ": " + ex.getMessage();
            String title = "Error starting the application";
            MainLoader.msg(title, msg, new Object[0]);
            System.exit(1);
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("org.openecard.versioncheck.Bundle");
    }

    private static String getMainClassName() throws ClassNotFoundException {
        String mainClass = System.getProperty("openecard.mainclass");
        if (mainClass != null) {
            mainClass = mainClass.trim();
            System.out.format("Main class defined in system property.%nmainclass=%s%n", mainClass);
            return mainClass;
        }
        String confFileName = "openecard/mainclass";
        InputStream is = MainLoader.class.getClassLoader().getResourceAsStream(confFileName);
        if (is == null) {
            is = MainLoader.class.getClassLoader().getResourceAsStream("/" + confFileName);
        }
        if (is != null) {
            Scanner s = new Scanner(is, "UTF-8");
            mainClass = s.nextLine();
            mainClass = mainClass.trim();
            System.out.format("Main class defined in config file.%nmainclass=%s%n", mainClass);
            return mainClass;
        }
        throw new ClassNotFoundException("No main class defined for deferred loading.");
    }

    private static Class<?> getMainClass(String className) throws ClassNotFoundException {
        return MainLoader.class.getClassLoader().loadClass(className);
    }

    private static Method getMainMethod(Class<?> clazz) throws NoSuchMethodException {
        for (Method m : clazz.getMethods()) {
            Class<?>[] params;
            Class<?> returnType;
            int mod;
            if (!"main".equals(m.getName()) || !Modifier.isPublic(mod = m.getModifiers()) || !Modifier.isStatic(mod) || !(returnType = m.getReturnType()).equals(Void.TYPE) && !returnType.equals(Void.class) || (params = m.getParameterTypes()).length != 1 || !params[0].equals(String[].class)) continue;
            return m;
        }
        throw new NoSuchMethodException("Failed to find main method.");
    }

    public static boolean checkJavaVersion(float versionReference) {
        String fullVersion = System.getProperty("java.version");
        String[] javaVersionElements = fullVersion.split("\\.|_|-b|\\+");
        String major1 = javaVersionElements[0];
        String major2 = javaVersionElements.length < 2 ? "0" : javaVersionElements[1];
        float javaVersion = Float.valueOf(major1 + "." + major2 + "f").floatValue();
        return javaVersion >= versionReference;
    }

    private static void msg(String title, String msg, Object ... obj) {
        String evalMsg = String.format(msg, obj);
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println(evalMsg);
        } else {
            JOptionPane.showMessageDialog(null, evalMsg, title, 0);
        }
    }
}

