/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.httpcore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpClientConnection;
import org.openecard.apache.http.HttpConnectionMetrics;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpEntityEnclosingRequest;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpMessage;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.config.MessageConstraints;
import org.openecard.apache.http.entity.BasicHttpEntity;
import org.openecard.apache.http.entity.ContentLengthStrategy;
import org.openecard.apache.http.impl.HttpConnectionMetricsImpl;
import org.openecard.apache.http.impl.entity.LaxContentLengthStrategy;
import org.openecard.apache.http.impl.entity.StrictContentLengthStrategy;
import org.openecard.apache.http.impl.io.ChunkedInputStream;
import org.openecard.apache.http.impl.io.ChunkedOutputStream;
import org.openecard.apache.http.impl.io.ContentLengthInputStream;
import org.openecard.apache.http.impl.io.ContentLengthOutputStream;
import org.openecard.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.openecard.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.openecard.apache.http.impl.io.IdentityInputStream;
import org.openecard.apache.http.impl.io.IdentityOutputStream;
import org.openecard.apache.http.io.HttpMessageParser;
import org.openecard.apache.http.io.HttpMessageWriter;
import org.openecard.apache.http.message.BasicHeader;
import org.openecard.common.AppVersion;
import org.openecard.transport.httpcore.StreamSessionInputBuffer;
import org.openecard.transport.httpcore.StreamSessionOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamHttpClientConnection
implements HttpClientConnection {
    private static final Logger logger = LoggerFactory.getLogger(StreamHttpClientConnection.class);
    private static final int BUFSIZE = 4096;
    private final InputStream in;
    private final OutputStream out;
    private final StreamSessionInputBuffer sin;
    private final StreamSessionOutputBuffer sout;
    private final HttpConnectionMetricsImpl metrics;
    private final HttpMessageParser<HttpResponse> responseParser;
    private final HttpMessageWriter<HttpRequest> requestWriter;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private boolean open = true;

    public StreamHttpClientConnection(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.sin = new StreamSessionInputBuffer(in, 4096);
        this.sout = new StreamSessionOutputBuffer(out, 4096);
        this.metrics = new HttpConnectionMetricsImpl(this.sin.getMetrics(), this.sout.getMetrics());
        this.requestWriter = DefaultHttpRequestWriterFactory.INSTANCE.create(this.sout);
        this.responseParser = DefaultHttpResponseParserFactory.INSTANCE.create(this.sin, MessageConstraints.DEFAULT);
        this.incomingContentStrategy = LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = StrictContentLengthStrategy.INSTANCE;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void shutdown() throws IOException {
        this.open = false;
        try {
            this.in.close();
        }
        catch (IOException ex) {
            logger.warn("Error forcibly closing input stream.");
        }
        try {
            this.out.close();
        }
        catch (IOException ex) {
            logger.warn("Error forcibly closing output stream.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.flush();
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void assertOpen() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("HTTP connection is closed.");
        }
    }

    @Override
    public void setSocketTimeout(int timeout) {
        logger.info("Not supported in this type of connection.");
    }

    @Override
    public int getSocketTimeout() {
        return 0;
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        return this.sin.isDataAvailable(timeout);
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        this.assertOpen();
        request.setHeader(new BasicHeader("User-Agent", AppVersion.getName() + "/" + AppVersion.getVersion()));
        this.requestWriter.write(request);
        this.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        this.assertOpen();
        HttpEntity entity = request.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outstream = this.prepareOutput(request);
        entity.writeTo(outstream);
        outstream.close();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        this.assertOpen();
        HttpEntity entity = this.prepareInput(response);
        response.setEntity(entity);
    }

    @Override
    public void flush() throws IOException {
        this.sout.flush();
    }

    @Override
    public boolean isStale() {
        return this.isOpen();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }

    protected void incrementRequestCount() {
        this.metrics.incrementRequestCount();
    }

    protected void incrementResponseCount() {
        this.metrics.incrementResponseCount();
    }

    protected OutputStream createOutputStream(long len) {
        if (len == -2L) {
            return new ChunkedOutputStream(2048, this.sout);
        }
        if (len == -1L) {
            return new IdentityOutputStream(this.sout);
        }
        return new ContentLengthOutputStream(this.sout, len);
    }

    protected OutputStream prepareOutput(HttpMessage message) throws HttpException {
        long len = this.outgoingContentStrategy.determineLength(message);
        return this.createOutputStream(len);
    }

    protected InputStream createInputStream(long len) {
        if (len == -2L) {
            return new ChunkedInputStream(this.sin);
        }
        if (len == -1L) {
            return new IdentityInputStream(this.sin);
        }
        return new ContentLengthInputStream(this.sin, len);
    }

    protected HttpEntity prepareInput(HttpMessage message) throws HttpException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.incomingContentStrategy.determineLength(message);
        InputStream instream = this.createInputStream(len);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(instream);
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(instream);
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(instream);
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }
}

