/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.smartcardio.CardException;
import org.openecard.common.ifd.scio.SCIOErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCExceptionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PCSCExceptionExtractor.class);

    public static SCIOErrorCode getCode(@Nonnull CardException mainException) {
        Class<?> c;
        Throwable cause = mainException.getCause();
        if (cause != null && "sun.security.smartcardio.PCSCException".equals((c = cause.getClass()).getName())) {
            try {
                Field f = c.getDeclaredField("code");
                f.setAccessible(true);
                int code = f.getInt(cause);
                return SCIOErrorCode.getErrorCode(code);
            }
            catch (NoSuchFieldException ex) {
                logger.error("Failed to find field 'code' in PCSCException.");
            }
            catch (IllegalAccessException ex) {
                logger.error("Failed to read field 'code' in PCSCException.");
            }
            catch (SecurityException ex) {
                logger.error("Failed access field 'code' in PCSCException or change its accessibility.");
            }
        }
        return SCIOErrorCode.SCARD_F_UNKNOWN_ERROR;
    }
}

