/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.ifd.scio.SCIOChannel;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.scio.PCSCCard;
import org.openecard.scio.PCSCExceptionExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCChannel
implements SCIOChannel {
    private static final Logger logger = LoggerFactory.getLogger(PCSCChannel.class);
    private final PCSCCard card;
    private final CardChannel channel;
    private final int channelNum;

    PCSCChannel(@Nonnull PCSCCard card, @Nonnull CardChannel channel) {
        this.card = card;
        this.channel = channel;
        int num = 0;
        try {
            num = channel.getChannelNumber();
        }
        catch (IllegalStateException ex) {
            String msg = "Card disconnected during connect phase, pretending to be channel 0 regardless of what it is.";
            logger.error(msg);
        }
        this.channelNum = num;
    }

    @Override
    public PCSCCard getCard() {
        return this.card;
    }

    @Override
    public int getChannelNumber() {
        return this.channelNum;
    }

    @Override
    public boolean isBasicChannel() {
        return this.channel.getChannelNumber() == 0;
    }

    @Override
    public boolean isLogicalChannel() {
        return !this.isBasicChannel();
    }

    @Override
    public CardResponseAPDU transmit(byte[] command) throws SCIOException {
        try {
            CommandAPDU convertCommand = new CommandAPDU(command);
            ResponseAPDU response = this.channel.transmit(convertCommand);
            return new CardResponseAPDU(response.getBytes());
        }
        catch (CardException ex) {
            String msg = "Failed to transmit APDU to the card in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.card.getTerminal().getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public CardResponseAPDU transmit(CardCommandAPDU apdu) throws SCIOException {
        return this.transmit(apdu.toByteArray());
    }

    @Override
    public int transmit(ByteBuffer command, ByteBuffer response) throws SCIOException {
        try {
            return this.channel.transmit(command, response);
        }
        catch (CardException ex) {
            String msg = "Failed to transmit APDU to the card in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.card.getTerminal().getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public void close() throws SCIOException {
        if (this.isLogicalChannel()) {
            try {
                this.channel.close();
            }
            catch (CardException ex) {
                String msg = "Failed to close channel to card in terminal '%s'.";
                throw new SCIOException(String.format(msg, this.card.getTerminal().getName()), PCSCExceptionExtractor.getCode(ex), ex);
            }
        }
    }
}

