/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import org.openecard.common.ifd.scio.SCIOATR;
import org.openecard.common.ifd.scio.SCIOCard;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOProtocol;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.scio.PCSCChannel;
import org.openecard.scio.PCSCExceptionExtractor;
import org.openecard.scio.PCSCTerminal;

public class PCSCCard
implements SCIOCard {
    private final PCSCTerminal terminal;
    private final Card card;

    PCSCCard(PCSCTerminal terminal, Card card) {
        this.terminal = terminal;
        this.card = card;
    }

    @Override
    public SCIOTerminal getTerminal() {
        return this.terminal;
    }

    @Override
    public SCIOATR getATR() {
        ATR atr = this.card.getATR();
        return new SCIOATR(atr.getBytes());
    }

    @Override
    public SCIOProtocol getProtocol() {
        String proto = this.card.getProtocol();
        return SCIOProtocol.getType(proto);
    }

    @Override
    public PCSCChannel getBasicChannel() {
        return new PCSCChannel(this, this.card.getBasicChannel());
    }

    @Override
    public PCSCChannel openLogicalChannel() throws SCIOException {
        try {
            return new PCSCChannel(this, this.card.openLogicalChannel());
        }
        catch (CardException ex) {
            String msg = "Failed to open logical channel to card in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.terminal.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public void beginExclusive() throws SCIOException {
        try {
            this.card.beginExclusive();
        }
        catch (CardException ex) {
            String msg = "Failed to get exclusive access to the card in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.terminal.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public void endExclusive() throws SCIOException {
        try {
            this.card.endExclusive();
        }
        catch (CardException ex) {
            String msg = "Failed to release exclusive access to the card in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.terminal.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public byte[] transmitControlCommand(int controlCode, byte[] command) throws SCIOException {
        try {
            return this.card.transmitControlCommand(controlCode, command);
        }
        catch (CardException ex) {
            String msg = "Failed to transmit control command to the terminal '%s'.";
            throw new SCIOException(String.format(msg, this.terminal.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public void disconnect(boolean reset) throws SCIOException {
        try {
            this.card.disconnect(reset);
        }
        catch (CardException ex) {
            String msg = "Failed to disconnect (reset=%b) the card in terminal '%s'.";
            throw new SCIOException(String.format(msg, reset, this.terminal.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }
}

