/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.pincompare;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityServiceActionName;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.InputUnitType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PinInputType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import java.math.BigInteger;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.pin.PINCompareDIDAuthenticateInputType;
import org.openecard.common.anytype.pin.PINCompareDIDAuthenticateOutputType;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.anytype.PINCompareMarkerType;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.util.PINUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIDAuthenticateStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(DIDAuthenticateStep.class);
    private final Dispatcher dispatcher;

    public DIDAuthenticateStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate request, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = (DIDAuthenticateResponse)WSHelper.makeResponse(DIDAuthenticateResponse.class, WSHelper.makeResultOK());
        char[] rawPIN = null;
        try {
            byte[] responseCode;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            String didName = SALUtils.getDIDName(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            PINCompareDIDAuthenticateInputType pinCompareInput = new PINCompareDIDAuthenticateInputType(request.getAuthenticationProtocolData());
            PINCompareDIDAuthenticateOutputType pinCompareOutput = pinCompareInput.getOutputType();
            byte[] cardApplication = request.getDIDScope() != null && request.getDIDScope().equals((Object)DIDScopeType.GLOBAL) ? cardStateEntry.getInfo().getApplicationIdByDidName(request.getDIDName(), request.getDIDScope()) : connectionHandle.getCardApplication();
            Assert.securityConditionDID(cardStateEntry, cardApplication, didName, DifferentialIdentityServiceActionName.DID_AUTHENTICATE);
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplication);
            PINCompareMarkerType pinCompareMarker = new PINCompareMarkerType(didStructure.getDIDMarker());
            byte keyRef = pinCompareMarker.getPINRef().getKeyRef()[0];
            byte[] slotHandle = connectionHandle.getSlotHandle();
            PasswordAttributesType attributes = pinCompareMarker.getPasswordAttributes();
            rawPIN = pinCompareInput.getPIN();
            pinCompareInput.setPIN(null);
            byte[] template = new byte[]{0, 32, 0, keyRef};
            if (rawPIN == null || rawPIN.length == 0) {
                VerifyUser verify = new VerifyUser();
                verify.setSlotHandle(slotHandle);
                InputUnitType inputUnit = new InputUnitType();
                verify.setInputUnit(inputUnit);
                PinInputType pinInput = new PinInputType();
                inputUnit.setPinInput(pinInput);
                pinInput.setIndex(BigInteger.ZERO);
                pinInput.setPasswordAttributes(attributes);
                verify.setTemplate(template);
                VerifyUserResponse verifyR = (VerifyUserResponse)this.dispatcher.safeDeliver(verify);
                WSHelper.checkResult(verifyR);
                responseCode = verifyR.getResponse();
            } else {
                Transmit verifyTransmit = PINUtils.buildVerifyTransmit(rawPIN, attributes, template, slotHandle);
                try {
                    TransmitResponse transResp = (TransmitResponse)this.dispatcher.safeDeliver(verifyTransmit);
                    WSHelper.checkResult(transResp);
                    responseCode = transResp.getOutputAPDU().get(0);
                }
                finally {
                    for (InputAPDUInfoType apdu : verifyTransmit.getInputAPDUInfo()) {
                        byte[] rawApdu = apdu.getInputAPDU();
                        if (rawApdu == null) continue;
                        java.util.Arrays.fill(rawApdu, (byte)0);
                    }
                }
            }
            CardResponseAPDU verifyResponseAPDU = new CardResponseAPDU(responseCode);
            if (verifyResponseAPDU.isWarningProcessed()) {
                pinCompareOutput.setRetryCounter(new BigInteger(Integer.toString(verifyResponseAPDU.getSW2() & 0xF)));
            }
            cardStateEntry.addAuthenticated(didName, cardApplication);
            response.setAuthenticationProtocolData(pinCompareOutput.getAuthDataType());
            if (rawPIN == null) return response;
        }
        catch (ECardException e) {
            LOG.error(e.getMessage(), e);
            response.setResult(e.getResult());
            return response;
        }
        catch (Exception e2) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            LOG.error(e2.getMessage(), e2);
            response.setResult(WSHelper.makeResult(e2));
            return response;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (rawPIN != null) {
                Arrays.fill(rawPIN, ' ');
            }
        }
        Arrays.fill(rawPIN, ' ');
        return response;
    }
}

