/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.genericcryptography;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashGenerationInfoType;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.crypto.common.HashAlgorithms;
import org.openecard.crypto.common.SignatureAlgorithms;
import org.openecard.crypto.common.UnsupportedAlgorithmException;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashStep
implements ProtocolStep<Hash, HashResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HashStep.class);
    private final Dispatcher dispatcher;

    public HashStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.Hash;
    }

    @Override
    public HashResponse perform(Hash request, Map<String, Object> internalData) {
        HashResponse response = (HashResponse)WSHelper.makeResponse(HashResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            String didName = SALUtils.getDIDName(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            DIDStructureType didStructure = SALUtils.getDIDStructure(request, didName, cardStateEntry, connectionHandle);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didStructure.getDIDMarker());
            HashGenerationInfoType hashInfo = cryptoMarker.getHashGenerationInfo();
            if (hashInfo != null && hashInfo != HashGenerationInfoType.NOT_ON_CARD) {
                String msg = String.format("Unsupported Hash generation type (%s) requested.", new Object[]{hashInfo});
                LOG.error(msg);
                String minor = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction";
                response.setResult(WSHelper.makeResultError(minor, msg));
            } else {
                String algId = cryptoMarker.getAlgorithmInfo().getAlgorithmIdentifier().getAlgorithm();
                SignatureAlgorithms alg = SignatureAlgorithms.fromAlgId(algId);
                HashAlgorithms hashAlg = alg.getHashAlg();
                if (hashAlg == null) {
                    String msg = String.format("Algorithm %s does not specify a Hash algorithm.", algId);
                    LOG.error(msg);
                    String minor = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter";
                    response.setResult(WSHelper.makeResultError(minor, msg));
                } else {
                    MessageDigest md = MessageDigest.getInstance(hashAlg.getJcaAlg());
                    md.update(request.getMessage());
                    byte[] digest = md.digest();
                    response.setHash(digest);
                }
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (NoSuchAlgorithmException | UnsupportedAlgorithmException e) {
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }
}

