/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import org.openecard.common.I18n;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.anytype.PACEMarkerType;

public class PINStep
extends Step {
    private static final I18n langEac = I18n.getTranslation("eac");
    private static final I18n langPace = I18n.getTranslation("pace");
    public static final String STEP_ID = "PROTOCOL_EAC_GUI_STEP_PIN";
    private static final String TITLE = "step_pace_title";
    private static final String STEP_DESCRIPTION = "step_pace_step_description";
    private static final String DESCRIPTION = "step_pace_description";
    private static final String DESCRIPTION_NATIVE = "step_pace_native_description";
    private static final String NOTICE = "eac_forward_notice";
    private static final String TRANSACTION_INFO = "transaction_info";
    public static final String PIN_FIELD = "PACE_PIN_FIELD";
    public static final String CAN_FIELD = "PACE_CAN_FIELD";
    private static final String CAN_NOTICE_ID = "PACE_CAN_NOTICE";
    private static final String PIN_ATTEMPTS_ID = "PACE_PIN_ATTEMPTS";
    private final String pinType;
    private final PACEMarkerType paceMarker;

    public PINStep(EACData eacData, boolean capturePin, PACEMarkerType paceMarker) {
        super(STEP_ID);
        this.pinType = langPace.translationForKey(eacData.passwordType, new Object[0]);
        this.paceMarker = paceMarker;
        this.setTitle(langPace.translationForKey(TITLE, this.pinType));
        this.setDescription(langPace.translationForKey(STEP_DESCRIPTION, new Object[0]));
        String transactionInfo = eacData.transactionInfo;
        if (transactionInfo != null) {
            Text transactionInfoField = new Text();
            transactionInfoField.setText(langEac.translationForKey(TRANSACTION_INFO, transactionInfo));
            this.getInputInfoUnits().add(transactionInfoField);
        }
        if (capturePin) {
            this.addSoftwareElements();
        } else {
            this.addTerminalElements();
        }
    }

    public static Step createDummy(String passwordType) {
        Step s = new Step(STEP_ID);
        String pinType = langPace.translationForKey(passwordType, new Object[0]);
        s.setTitle(langPace.translationForKey(TITLE, pinType));
        s.setDescription(langPace.translationForKey(STEP_DESCRIPTION, new Object[0]));
        return s;
    }

    private void addSoftwareElements() {
        this.setResetOnLoad(true);
        Text description = new Text();
        description.setText(langPace.translationForKey(DESCRIPTION, this.pinType));
        this.getInputInfoUnits().add(description);
        PasswordField pinInputField = new PasswordField(PIN_FIELD);
        pinInputField.setDescription(this.pinType);
        pinInputField.setMinLength(this.paceMarker.getMinLength());
        pinInputField.setMaxLength(this.paceMarker.getMaxLength());
        this.getInputInfoUnits().add(pinInputField);
        Text attemptCount = new Text();
        attemptCount.setText(langPace.translationForKey("step_pin_retrycount", 3));
        attemptCount.setID(PIN_ATTEMPTS_ID);
        this.getInputInfoUnits().add(attemptCount);
        Text notice = new Text();
        notice.setText(langEac.translationForKey(NOTICE, this.pinType));
        this.getInputInfoUnits().add(notice);
    }

    private void addTerminalElements() {
        this.setInstantReturn(true);
        Text description = new Text();
        description.setText(langPace.translationForKey(DESCRIPTION_NATIVE, this.pinType));
        this.getInputInfoUnits().add(description);
        Text notice = new Text();
        notice.setText(langEac.translationForKey(NOTICE, this.pinType));
        this.getInputInfoUnits().add(notice);
        Text attemptCount = new Text();
        attemptCount.setText(langPace.translationForKey("step_pin_retrycount", 3));
        attemptCount.setID(PIN_ATTEMPTS_ID);
        this.getInputInfoUnits().add(attemptCount);
    }

    protected void addCANEntry() {
        PasswordField canField = new PasswordField(CAN_FIELD);
        canField.setDescription(langPace.translationForKey("can", new Object[0]));
        canField.setMaxLength(6);
        canField.setMinLength(6);
        this.getInputInfoUnits().add(canField);
        Text canNotice = new Text();
        canNotice.setText(langEac.translationForKey("eac_can_notice", new Object[0]));
        canNotice.setID(CAN_NOTICE_ID);
        this.getInputInfoUnits().add(canNotice);
    }

    protected void addNativeCANNotice() {
        Text canNotice = new Text();
        canNotice.setText(langEac.translationForKey("eac_can_notice_native", new Object[0]));
        canNotice.setID(CAN_NOTICE_ID);
        this.getInputInfoUnits().add(canNotice);
    }

    protected void updateAttemptsDisplay(int newValue) {
        for (InputInfoUnit unit : this.getInputInfoUnits()) {
            if (!unit.getID().equals(PIN_ATTEMPTS_ID)) continue;
            Text text = (Text)unit;
            text.setText(langPace.translationForKey("step_pin_retrycount", newValue));
        }
    }
}

