/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.util.Promise;
import org.openecard.gui.executor.BackgroundTask;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.sal.protocol.eac.gui.ErrorStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardMonitor
implements BackgroundTask,
EventCallback {
    private static final Logger logger = LoggerFactory.getLogger(CardMonitor.class);
    private static final I18n langPin = I18n.getTranslation("pinplugin");
    private static final String ERROR_CARD_REMOVED = "action.error.card.removed";
    private static final String ERROR_TITLE = "action.error.title";
    private final Promise<Void> cardRemoved = new Promise();

    @Override
    public StepActionResult call() throws Exception {
        try {
            logger.debug("Waiting for card to be removed.");
            this.cardRemoved.deref();
            logger.debug("Card has been removed.");
            String title = langPin.translationForKey(ERROR_TITLE, new Object[0]);
            String desc = langPin.translationForKey(ERROR_CARD_REMOVED, new Object[0]);
            ErrorStep replacement = new ErrorStep(title, desc);
            DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
            dynCtx.put("org.openecard.tr03112.eac.pace_successful", WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Card has been removed.")));
            return new StepActionResult(StepActionResultStatus.REPEAT, replacement);
        }
        catch (InterruptedException ex) {
            logger.debug("Card has not been removed.");
            throw ex;
        }
    }

    @Override
    public void signalEvent(EventType eventType, EventObject eventData) {
        this.cardRemoved.deliver(null);
    }
}

