/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openecard.common.DynamicContext;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.Checkbox;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.BackgroundTask;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.anytype.PACEMarkerType;
import org.openecard.sal.protocol.eac.gui.PINStep;
import org.openecard.sal.protocol.eac.gui.PINStepAction;

public class CHATStepAction
extends StepAction {
    private final EACData eacData;
    private final BackgroundTask bTask;

    public CHATStepAction(EACData eacData, Step step) {
        super(step);
        this.eacData = eacData;
        this.bTask = step.getBackgroundTask();
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        if (result.isOK()) {
            this.processResult(oldResults);
            DynamicContext ctx = DynamicContext.getInstance("tr03112");
            boolean nativePace = (Boolean)ctx.get("org.openecard.tr03112.eac.is_native_pace");
            PACEMarkerType paceMarker = (PACEMarkerType)ctx.get("org.openecard.tr03112.eac.pace_marker");
            byte[] status = (byte[])ctx.get("org.openecard.tr03112.eac.pin_status_bytes");
            byte[] slotHandle = (byte[])ctx.get("org.openecard.tr03112.eac.slot_handle");
            Dispatcher dispatcher = (Dispatcher)ctx.get("org.openecard.tr03112.eac.dispatcher");
            PINStep pinStep = new PINStep(this.eacData, !nativePace, paceMarker);
            pinStep.setBackgroundTask(this.bTask);
            PINStepAction pinAction = new PINStepAction(this.eacData, !nativePace, slotHandle, dispatcher, pinStep, status);
            pinStep.setAction(pinAction);
            return new StepActionResult(StepActionResultStatus.NEXT, pinStep);
        }
        return new StepActionResult(StepActionResultStatus.BACK);
    }

    private void processResult(Map<String, ExecutionResults> results) {
        Checkbox cbWrite;
        List<String> dataGroupsNames = this.getDataGroupNames();
        List<String> specialFunctionsNames = this.getSpecialFunctionNames();
        ExecutionResults executionResults = results.get(this.getStepID());
        Checkbox cbRead = (Checkbox)executionResults.getResult("ReadCHATCheckBoxes");
        if (cbRead != null) {
            CHAT selectedCHAT = this.eacData.requiredCHAT;
            for (BoxItem item : cbRead.getBoxItems()) {
                if (dataGroupsNames.contains(item.getName())) {
                    selectedCHAT.setReadAccess(item.getName(), item.isChecked());
                    continue;
                }
                if (!specialFunctionsNames.contains(item.getName())) continue;
                selectedCHAT.setSpecialFunction(item.getName(), item.isChecked());
            }
        }
        if ((cbWrite = (Checkbox)executionResults.getResult("WriteCHATCheckBoxes")) != null) {
            CHAT selectedCHAT = this.eacData.requiredCHAT;
            for (BoxItem item : cbWrite.getBoxItems()) {
                if (!dataGroupsNames.contains(item.getName())) continue;
                selectedCHAT.setWriteAccess(item.getName(), item.isChecked());
            }
        }
    }

    private List<String> getSpecialFunctionNames() {
        ArrayList<String> specialFunctionNames = new ArrayList<String>();
        for (CHAT.SpecialFunction dg : CHAT.SpecialFunction.values()) {
            specialFunctionNames.add(dg.name());
        }
        return specialFunctionNames;
    }

    private List<String> getDataGroupNames() {
        ArrayList<String> dataGroupNames = new ArrayList<String>();
        for (CHAT.DataGroup dg : CHAT.DataGroup.values()) {
            dataGroupNames.add(dg.name());
        }
        return dataGroupNames;
    }
}

