/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import java.util.Calendar;
import java.util.Map;
import org.openecard.common.I18n;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.Checkbox;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.ToggleText;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.gui.TR03119RightsFilter;

public class CHATStep
extends Step {
    private static final I18n lang = I18n.getTranslation("eac");
    public static final String STEP_ID = "PROTOCOL_EAC_GUI_STEP_CHAT";
    public static final String TITLE = "step_chat_title";
    public static final String STEP_DESCRIPTION = "step_chat_step_description";
    public static final String DESCRIPTION = "step_chat_description";
    public static final String NOTE = "step_chat_note";
    public static final String NOTE_CONTENT = "step_chat_note_content";
    public static final String READ_ACCESS_DESC = "step_chat_read_access_description";
    public static final String WRITE_ACCESS_DESC = "step_chat_write_access_description";
    public static final String READ_CHAT_BOXES = "ReadCHATCheckBoxes";
    public static final String WRITE_CHAT_BOXES = "WriteCHATCheckBoxes";
    private final EACData eacData;

    public CHATStep(EACData eacData) {
        super(STEP_ID);
        this.eacData = eacData;
        this.setTitle(lang.translationForKey(TITLE, new Object[0]));
        this.setDescription(lang.translationForKey(STEP_DESCRIPTION, new Object[0]));
        this.addElements();
    }

    public static Step createDummy() {
        Step s = new Step(STEP_ID);
        s.setTitle(lang.translationForKey(TITLE, new Object[0]));
        s.setDescription(lang.translationForKey(STEP_DESCRIPTION, new Object[0]));
        return s;
    }

    private void addElements() {
        Text decription = new Text();
        String decriptionText = lang.translationForKey(DESCRIPTION, this.eacData.certificateDescription.getSubjectName());
        decription.setText(decriptionText);
        this.getInputInfoUnits().add(decription);
        Checkbox readAccessCheckBox = new Checkbox(READ_CHAT_BOXES);
        boolean displayReadAccessCheckBox = false;
        readAccessCheckBox.setGroupText(lang.translationForKey(READ_ACCESS_DESC, new Object[0]));
        Map<CHAT.DataGroup, Boolean> requiredReadAccess = this.eacData.requiredCHAT.getReadAccess();
        Map<CHAT.DataGroup, Boolean> optionalReadAccess = this.eacData.optionalCHAT.getReadAccess();
        Map<CHAT.SpecialFunction, Boolean> requiredSpecialFunctions = this.eacData.requiredCHAT.getSpecialFunctions();
        Map<CHAT.SpecialFunction, Boolean> optionalSpecialFunctions = this.eacData.optionalCHAT.getSpecialFunctions();
        for (CHAT.DataGroup dataGroup : requiredReadAccess.keySet()) {
            if (TR03119RightsFilter.isTr03119ConformReadRight(dataGroup)) {
                if (requiredReadAccess.get((Object)dataGroup).booleanValue()) {
                    displayReadAccessCheckBox = true;
                    readAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, true, new Object[0]));
                    continue;
                }
                if (!optionalReadAccess.get((Object)dataGroup).booleanValue()) continue;
                displayReadAccessCheckBox = true;
                readAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, false, new Object[0]));
                continue;
            }
            this.eacData.requiredCHAT.setReadAccess(dataGroup, false);
        }
        for (CHAT.SpecialFunction specialFunction : requiredSpecialFunctions.keySet()) {
            Object[] textData = new Object[]{};
            if (CHAT.SpecialFunction.AGE_VERIFICATION == specialFunction) {
                Calendar c = this.eacData.aad.getAgeVerificationData();
                if (c != null) {
                    int yearDiff = CHATStep.getYearDifference(c);
                    textData = new Object[]{yearDiff};
                } else {
                    this.eacData.requiredCHAT.setSpecialFunctions(specialFunction, false);
                    continue;
                }
            }
            if (TR03119RightsFilter.isTr03119ConformSpecialFunction(specialFunction)) {
                if (requiredSpecialFunctions.get((Object)specialFunction).booleanValue()) {
                    displayReadAccessCheckBox = true;
                    readAccessCheckBox.getBoxItems().add(this.makeBoxItem(specialFunction, true, true, textData));
                    continue;
                }
                if (!optionalSpecialFunctions.get((Object)specialFunction).booleanValue()) continue;
                displayReadAccessCheckBox = true;
                readAccessCheckBox.getBoxItems().add(this.makeBoxItem(specialFunction, true, false, textData));
                continue;
            }
            this.eacData.requiredCHAT.setSpecialFunctions(specialFunction, false);
        }
        if (displayReadAccessCheckBox) {
            this.getInputInfoUnits().add(readAccessCheckBox);
        }
        Checkbox writeAccessCheckBox = new Checkbox(WRITE_CHAT_BOXES);
        boolean displayWriteAccessCheckBox = false;
        writeAccessCheckBox.setGroupText(lang.translationForKey(WRITE_ACCESS_DESC, new Object[0]));
        Map<CHAT.DataGroup, Boolean> requiredWriteAccess = this.eacData.requiredCHAT.getWriteAccess();
        Map<CHAT.DataGroup, Boolean> optionalWriteAccess = this.eacData.optionalCHAT.getWriteAccess();
        for (CHAT.DataGroup dataGroup : requiredWriteAccess.keySet()) {
            if (TR03119RightsFilter.isTr03119ConformWriteRight(dataGroup)) {
                if (requiredWriteAccess.get((Object)dataGroup).booleanValue()) {
                    displayWriteAccessCheckBox = true;
                    writeAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, true, new Object[0]));
                    continue;
                }
                if (!optionalWriteAccess.get((Object)dataGroup).booleanValue()) continue;
                displayWriteAccessCheckBox = true;
                writeAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, false, new Object[0]));
                continue;
            }
            this.eacData.requiredCHAT.setWriteAccess(dataGroup, false);
        }
        if (displayWriteAccessCheckBox) {
            this.getInputInfoUnits().add(writeAccessCheckBox);
        }
        ToggleText requestedDataDescription = new ToggleText();
        requestedDataDescription.setTitle(lang.translationForKey(NOTE, new Object[0]));
        requestedDataDescription.setText(lang.translationForKey(NOTE_CONTENT, new Object[0]));
        requestedDataDescription.setCollapsed(false);
        this.getInputInfoUnits().add(requestedDataDescription);
    }

    private BoxItem makeBoxItem(Enum<?> value, boolean checked, boolean disabled, Object ... textData) {
        BoxItem item = new BoxItem();
        item.setName(value.name());
        item.setChecked(checked);
        item.setDisabled(disabled);
        item.setText(lang.translationForKey(value.name(), textData));
        return item;
    }

    private static int getYearDifference(Calendar c) {
        Calendar now = Calendar.getInstance();
        now.add(5, -1 * c.get(5));
        now.add(5, 1);
        now.add(2, -1 * c.get(2));
        now.add(2, 1);
        now.add(1, -1 * c.get(1));
        return now.get(1);
    }
}

