/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import org.openecard.common.apdu.ExternalAuthentication;
import org.openecard.common.apdu.GetChallenge;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.protocol.exception.ProtocolException;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.sal.protocol.eac.apdu.MSESetATTA;
import org.openecard.sal.protocol.eac.apdu.MSESetDST;
import org.openecard.sal.protocol.eac.apdu.PSOVerifyCertificate;

public class TerminalAuthentication {
    private final Dispatcher dispatcher;
    private final byte[] slotHandle;

    public TerminalAuthentication(Dispatcher dispatcher, byte[] slotHandle) {
        this.dispatcher = dispatcher;
        this.slotHandle = slotHandle;
    }

    public void verifyCertificates(CardVerifiableCertificateChain certificateChain) throws ProtocolException {
        try {
            for (CardVerifiableCertificate cvc : certificateChain.getCertificates()) {
                MSESetDST mseSetDST = new MSESetDST(cvc.getCAR().toByteArray());
                mseSetDST.transmit(this.dispatcher, this.slotHandle);
                PSOVerifyCertificate psovc = new PSOVerifyCertificate(cvc.getCertificate().getValue());
                psovc.transmit(this.dispatcher, this.slotHandle);
            }
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public void mseSetAT(byte[] oID, byte[] chr, byte[] key, byte[] aad) throws ProtocolException {
        try {
            MSESetATTA mseSetAT = new MSESetATTA(oID, chr, key, aad);
            mseSetAT.transmit(this.dispatcher, this.slotHandle);
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public void externalAuthentication(byte[] terminalSignature) throws ProtocolException {
        try {
            ExternalAuthentication externalAuthentication = new ExternalAuthentication(terminalSignature);
            externalAuthentication.transmit(this.dispatcher, this.slotHandle);
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public byte[] getChallenge() throws ProtocolException {
        try {
            GetChallenge getChallenge = new GetChallenge();
            CardResponseAPDU response = getChallenge.transmit(this.dispatcher, this.slotHandle);
            return response.getData();
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }
}

