/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.interfaces.ObjectSchemaValidator;
import org.openecard.common.interfaces.ObjectValidatorException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.Promise;
import org.openecard.common.util.TR03112Utils;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.crypto.common.asn1.cvc.CHATVerifier;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateVerifier;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.openecard.crypto.common.asn1.eac.AuthenticatedAuxiliaryData;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC1InputType;
import org.openecard.sal.protocol.eac.anytype.EAC1OutputType;
import org.openecard.sal.protocol.eac.anytype.ElementParsingException;
import org.openecard.sal.protocol.eac.anytype.PACEMarkerType;
import org.openecard.sal.protocol.eac.anytype.PasswordID;
import org.openecard.sal.protocol.eac.gui.CHATStep;
import org.openecard.sal.protocol.eac.gui.CVCStep;
import org.openecard.sal.protocol.eac.gui.CVCStepAction;
import org.openecard.sal.protocol.eac.gui.CardMonitor;
import org.openecard.sal.protocol.eac.gui.CardRemovedFilter;
import org.openecard.sal.protocol.eac.gui.PINStep;
import org.openecard.sal.protocol.eac.gui.ProcessingStep;
import org.openecard.sal.protocol.eac.gui.ProcessingStepAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PACEStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(PACEStep.class.getName());
    private static final I18n LANG = I18n.getTranslation("eac");
    private static final I18n LANG_PACE = I18n.getTranslation("pace");
    private static final String TITLE = "eac_user_consent_title";
    private final Dispatcher dispatcher;
    private final UserConsent gui;
    private final EventDispatcher eventDispatcher;

    public PACEStep(Dispatcher dispatcher, UserConsent gui, EventDispatcher eventManager) {
        this.dispatcher = dispatcher;
        this.gui = gui;
        this.eventDispatcher = eventManager;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate request, Map<String, Object> internalData) {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        DIDAuthenticate didAuthenticate = request;
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        ConnectionHandleType conHandle = (ConnectionHandleType)dynCtx.get("connection_handle");
        try {
            ObjectSchemaValidator valid = (ObjectSchemaValidator)dynCtx.getPromise("org.openecard.tr03112.eac.schema_validator").deref();
            boolean messageValid = valid.validateObject(request);
            if (!messageValid) {
                String msg = "Validation of the EAC1InputType message failed.";
                LOG.error(msg);
                dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", msg));
                return response;
            }
        }
        catch (ObjectValidatorException ex) {
            String msg = "Validation of the EAC1InputType message failed due to invalid input data.";
            LOG.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        catch (InterruptedException ex) {
            String msg = "Thread interrupted while waiting for schema validator instance.";
            LOG.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        if (!ByteUtils.compare(conHandle.getSlotHandle(), didAuthenticate.getConnectionHandle().getSlotHandle())) {
            String msg = "Invalid connection handle given in DIDAuthenticate message.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownConnectionHandle", msg);
            response.setResult(r);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            return response;
        }
        byte[] slotHandle = conHandle.getSlotHandle();
        dynCtx.put("org.openecard.tr03112.eac.slot_handle", slotHandle);
        dynCtx.put("org.openecard.tr03112.eac.dispatcher", this.dispatcher);
        try {
            EAC1InputType eac1Input = new EAC1InputType(didAuthenticate.getAuthenticationProtocolData());
            EAC1OutputType eac1Output = eac1Input.getOutputType();
            AuthenticatedAuxiliaryData aad = new AuthenticatedAuxiliaryData(eac1Input.getAuthenticatedAuxiliaryData());
            byte pinID = PasswordID.valueOf(didAuthenticate.getDIDName()).getByte();
            String passwordType = PasswordID.parse(pinID).getString();
            boolean nativePace = this.genericPACESupport(conHandle);
            dynCtx.put("org.openecard.tr03112.eac.is_native_pace", nativePace);
            CardVerifiableCertificateChain certChain = new CardVerifiableCertificateChain(eac1Input.getCertificates());
            byte[] rawCertificateDescription = eac1Input.getCertificateDescription();
            CertificateDescription certDescription = CertificateDescription.getInstance(rawCertificateDescription);
            dynCtx.put("eservice_certificate_description", certDescription);
            Result activationChecksResult = this.performChecks(certDescription, dynCtx);
            if (!"http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok".equals(activationChecksResult.getResultMajor())) {
                response.setResult(activationChecksResult);
                dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
                return response;
            }
            CHAT requiredCHAT = new CHAT(eac1Input.getRequiredCHAT());
            CHAT optionalCHAT = new CHAT(eac1Input.getOptionalCHAT());
            CardStateEntry cardState = (CardStateEntry)internalData.get("cardState");
            PACEMarkerType paceMarker = this.getPaceMarker(cardState, passwordType);
            dynCtx.put("org.openecard.tr03112.eac.pace_marker", paceMarker);
            CardVerifiableCertificate taCert = certChain.getTerminalCertificate();
            CardVerifiableCertificateVerifier.verify(taCert, certDescription);
            CHAT taCHAT = taCert.getCHAT();
            if (taCHAT.getRole() != CHAT.Role.AUTHENTICATION_TERMINAL) {
                String msg = "Unsupported terminal type in Terminal Certificate referenced. Refernced terminal type is " + taCHAT.getRole().toString() + ".";
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", msg));
                dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
                return response;
            }
            CHATVerifier.verfiy(taCHAT, requiredCHAT);
            optionalCHAT.restrictAccessRights(taCHAT);
            EACData eacData = new EACData();
            eacData.didRequest = didAuthenticate;
            eacData.certificate = certChain.getTerminalCertificate();
            eacData.certificateDescription = certDescription;
            eacData.rawCertificateDescription = rawCertificateDescription;
            eacData.transactionInfo = eac1Input.getTransactionInfo();
            eacData.requiredCHAT = requiredCHAT;
            eacData.optionalCHAT = optionalCHAT;
            eacData.selectedCHAT = requiredCHAT;
            eacData.aad = aad;
            eacData.pinID = pinID;
            eacData.passwordType = passwordType;
            dynCtx.put("org.openecard.tr03112.eac.eac_data", eacData);
            InputAPDUInfoType input = new InputAPDUInfoType();
            input.setInputAPDU(new byte[]{0, 34, -63, -92, 15, -128, 10, 4, 0, 127, 0, 7, 2, 2, 4, 2, 2, -125, 1, 3});
            input.getAcceptableStatusCode().add(new byte[]{-112, 0});
            input.getAcceptableStatusCode().add(new byte[]{99, -62});
            input.getAcceptableStatusCode().add(new byte[]{99, -63});
            input.getAcceptableStatusCode().add(new byte[]{99, -64});
            input.getAcceptableStatusCode().add(new byte[]{98, -125});
            Transmit transmit = new Transmit();
            transmit.setSlotHandle(slotHandle);
            transmit.getInputAPDUInfo().add(input);
            TransmitResponse pinCheckResponse = (TransmitResponse)this.dispatcher.safeDeliver(transmit);
            byte[] output = pinCheckResponse.getOutputAPDU().get(0);
            CardResponseAPDU outputApdu = new CardResponseAPDU(output);
            byte[] status = outputApdu.getStatusBytes();
            dynCtx.put("org.openecard.tr03112.eac.pin_status_bytes", status);
            boolean pinUsable = !Arrays.equals(status, new byte[]{99, -64});
            final UserConsentDescription uc = new UserConsentDescription(LANG.translationForKey(TITLE, new Object[0]));
            if (pinUsable) {
                CardMonitor cardMon = new CardMonitor();
                CardRemovedFilter filter = new CardRemovedFilter(conHandle.getIFDName(), conHandle.getSlotIndex());
                this.eventDispatcher.add((EventCallback)cardMon, filter);
                CVCStep cvcStep = new CVCStep(eacData);
                cvcStep.setBackgroundTask(cardMon);
                CVCStepAction cvcStepAction = new CVCStepAction(cvcStep);
                cvcStep.setAction(cvcStepAction);
                uc.getSteps().add(cvcStep);
                uc.getSteps().add(CHATStep.createDummy());
                uc.getSteps().add(PINStep.createDummy(passwordType));
                ProcessingStep procStep = new ProcessingStep();
                ProcessingStepAction procStepAction = new ProcessingStepAction(procStep);
                procStep.setAction(procStepAction);
                uc.getSteps().add(procStep);
            } else {
                dynCtx.put("org.openecard.tr03112.eac.pace_successful", WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked", "The PIN is blocked.")));
            }
            Thread guiThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
                    if (!uc.getSteps().isEmpty()) {
                        Promise<Object> pPaceSuccessful;
                        UserConsentNavigator navigator = PACEStep.this.gui.obtainNavigator(uc);
                        dynCtx.put("user_consent_navigator", navigator);
                        ExecutionEngine exec = new ExecutionEngine(navigator);
                        ResultStatus guiResult = exec.process();
                        dynCtx.put("org.openecard.tr03112.eac.gui_result", (Object)guiResult);
                        if (guiResult == ResultStatus.CANCEL && !(pPaceSuccessful = dynCtx.getPromise("org.openecard.tr03112.eac.pace_successful")).isDelivered()) {
                            pPaceSuccessful.deliver(WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", "User canceled the PACE dialog.")));
                        }
                    }
                }
            }, "EAC-GUI");
            guiThread.start();
            Promise<Object> pPaceException = dynCtx.getPromise("org.openecard.tr03112.eac.pace_successful");
            Object pPaceError = pPaceException.deref();
            if (pPaceError != null) {
                Result r;
                String msg;
                if (pPaceError instanceof WSHelper.WSException) {
                    response.setResult(((WSHelper.WSException)pPaceError).getResult());
                    return response;
                }
                if (pPaceError instanceof DispatcherException | pPaceError instanceof InvocationTargetException) {
                    msg = "Internal error while PACE authentication.";
                    r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg);
                    response.setResult(r);
                    return response;
                }
                msg = "Unknown error while PACE authentication.";
                r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError", msg);
                response.setResult(r);
                return response;
            }
            TerminalAuthentication ta = new TerminalAuthentication(this.dispatcher, slotHandle);
            byte[] challenge = ta.getChallenge();
            DIDAuthenticationDataType data = eacData.paceResponse.getAuthenticationProtocolData();
            AuthDataMap paceOutputMap = new AuthDataMap(data);
            byte[] efCardAccess = paceOutputMap.getContentAsBytes("EFCardAccess");
            byte[] currentCAR = paceOutputMap.getContentAsBytes("CARcurr");
            byte[] previousCAR = paceOutputMap.getContentAsBytes("CARprev");
            byte[] idpicc = paceOutputMap.getContentAsBytes("IDPICC");
            SecurityInfos securityInfos = SecurityInfos.getInstance(efCardAccess);
            internalData.put("SecurityInfos", securityInfos);
            internalData.put("AuthenticatedAuxiliaryData", aad);
            internalData.put("Certificates", certChain);
            internalData.put("CurrentCAR", currentCAR);
            internalData.put("PreviousCAR", previousCAR);
            internalData.put("Challenge", challenge);
            eac1Output.setCHAT(eacData.selectedCHAT.toByteArray());
            eac1Output.setCurrentCAR(currentCAR);
            eac1Output.setPreviousCAR(previousCAR);
            eac1Output.setEFCardAccess(efCardAccess);
            eac1Output.setIDPICC(idpicc);
            eac1Output.setChallenge(challenge);
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac1Output.getAuthDataType());
        }
        catch (CertificateException ex) {
            LOG.error(ex.getMessage(), ex);
            String msg = ex.getMessage();
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal/mEAC#DocumentValidityVerificationFailed", msg));
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        catch (WSHelper.WSException e) {
            LOG.error(e.getMessage(), e);
            response.setResult(e.getResult());
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        catch (ElementParsingException ex) {
            LOG.error(ex.getMessage(), ex);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", ex.getMessage()));
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        return response;
    }

    private PACEMarkerType getPaceMarker(CardStateEntry cardState, String pinType) {
        byte[] applicationIdentifier = cardState.getCurrentCardApplication().getApplicationIdentifier();
        DIDStructureType didStructure = cardState.getDIDStructure(pinType, applicationIdentifier);
        iso.std.iso_iec._24727.tech.schema.PACEMarkerType didMarker = (iso.std.iso_iec._24727.tech.schema.PACEMarkerType)didStructure.getDIDMarker();
        return new PACEMarkerType(didMarker);
    }

    private boolean convertToBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private Result performChecks(CertificateDescription certDescription, DynamicContext dynCtx) {
        Object objectActivation = dynCtx.get("object_activation");
        Object tokenChecks = dynCtx.get("tctoken_checks");
        if (this.convertToBoolean(tokenChecks)) {
            boolean checkPassed = this.checkEserviceCertificate(certDescription, dynCtx);
            if (!checkPassed) {
                String msg = "Hash of eService certificate is NOT contained in the CertificateDescription.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#prerequisitesNotSatisfied", msg);
                return r;
            }
            if (!this.convertToBoolean(objectActivation)) {
                checkPassed = this.checkTCTokenServerCertificates(certDescription, dynCtx);
                if (!checkPassed) {
                    String msg = "Hash of the TCToken server certificate is NOT contained in the CertificateDescription.";
                    Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#prerequisitesNotSatisfied", msg);
                    return r;
                }
                checkPassed = this.checkTCTokenAndSubjectURL(certDescription, dynCtx);
                if (!checkPassed) {
                    String msg = "TCToken does not come from the server to which the authorization certificate was issued.";
                    Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#prerequisitesNotSatisfied", msg);
                    return r;
                }
            } else {
                LOG.warn("Checks according to BSI TR03112 3.4.4 (TCToken specific) skipped.");
            }
        } else {
            LOG.warn("Checks according to BSI TR03112 3.4.4 skipped.");
        }
        return WSHelper.makeResultOK();
    }

    private boolean checkTCTokenAndSubjectURL(CertificateDescription certDescription, DynamicContext dynCtx) {
        URL tcTokenURL = (URL)dynCtx.get("TCTokenURL");
        if (tcTokenURL != null) {
            try {
                URL subjectURL = new URL(certDescription.getSubjectURL());
                return TR03112Utils.checkSameOriginPolicy(tcTokenURL, subjectURL);
            }
            catch (MalformedURLException e) {
                LOG.error("SubjectURL in CertificateDescription is not a well formed URL.");
                return false;
            }
        }
        LOG.error("No TC Token URL set in Dynamic Context.");
        return false;
    }

    private boolean checkEserviceCertificate(CertificateDescription certDescription, DynamicContext dynCtx) {
        TlsServerCertificate certificate = (TlsServerCertificate)dynCtx.get("eservice_certificate");
        if (certificate != null) {
            return TR03112Utils.isInCommCertificates(certificate, certDescription.getCommCertificates());
        }
        LOG.error("No eService TLS Certificate set in Dynamic Context.");
        return false;
    }

    private boolean checkTCTokenServerCertificates(CertificateDescription certDescription, DynamicContext dynCtx) {
        List certificates = (List)dynCtx.get("tctoken_server_certificates");
        if (certificates != null) {
            for (Pair cert : certificates) {
                TlsServerCertificate bcCert;
                if (!(cert instanceof Pair) || TR03112Utils.isInCommCertificates(bcCert = (TlsServerCertificate)cert.p2, certDescription.getCommCertificates())) continue;
                return false;
            }
            return true;
        }
        LOG.error("No TC Token server certificates set in Dynamic Context.");
        return false;
    }

    private boolean genericPACESupport(ConnectionHandleType connectionHandle) throws WSHelper.WSException {
        GetIFDCapabilities capabilitiesRequest = new GetIFDCapabilities();
        capabilitiesRequest.setContextHandle(connectionHandle.getContextHandle());
        capabilitiesRequest.setIFDName(connectionHandle.getIFDName());
        GetIFDCapabilitiesResponse capabilitiesResponse = (GetIFDCapabilitiesResponse)this.dispatcher.safeDeliver(capabilitiesRequest);
        WSHelper.checkResult(capabilitiesResponse);
        if (capabilitiesResponse.getIFDCapabilities() != null) {
            List<SlotCapabilityType> capabilities = capabilitiesResponse.getIFDCapabilities().getSlotCapability();
            String genericPACE = PACECapabilities.PACECapability.GenericPACE.getProtocol();
            for (SlotCapabilityType capability : capabilities) {
                if (!capability.getIndex().equals(connectionHandle.getSlotIndex())) continue;
                for (String protocol : capability.getProtocol()) {
                    if (!protocol.equals(genericPACE)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

