/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.DynamicContext;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.ObjectSchemaValidator;
import org.openecard.common.interfaces.ObjectValidatorException;
import org.openecard.common.sal.protocol.exception.ProtocolException;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.Promise;
import org.openecard.sal.protocol.eac.AuthenticationHelper;
import org.openecard.sal.protocol.eac.ChipAuthentication;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.openecard.sal.protocol.eac.anytype.EACAdditionalInputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipAuthenticationStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ChipAuthenticationStep.class.getName());
    private final Dispatcher dispatcher;

    public ChipAuthenticationStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate didAuthenticate, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        byte[] slotHandle = didAuthenticate.getConnectionHandle().getSlotHandle();
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        try {
            ObjectSchemaValidator valid = (ObjectSchemaValidator)dynCtx.getPromise("org.openecard.tr03112.eac.schema_validator").deref();
            boolean messageValid = valid.validateObject(didAuthenticate);
            if (!messageValid) {
                String msg = "Validation of the EACAdditionalInputType message failed.";
                logger.error(msg);
                dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", msg));
                return response;
            }
        }
        catch (ObjectValidatorException ex) {
            String msg = "Validation of the EACAdditionalInputType message failed due to invalid input data.";
            logger.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        catch (InterruptedException ex) {
            String msg = "Thread interrupted while waiting for schema validator instance.";
            logger.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        try {
            EACAdditionalInputType eacAdditionalInput = new EACAdditionalInputType(didAuthenticate.getAuthenticationProtocolData());
            EAC2OutputType eac2Output = eacAdditionalInput.getOutputType();
            TerminalAuthentication ta = new TerminalAuthentication(this.dispatcher, slotHandle);
            ChipAuthentication ca = new ChipAuthentication(this.dispatcher, slotHandle);
            byte[] signature = eacAdditionalInput.getSignature();
            internalData.put("Signature", signature);
            AuthenticationHelper auth = new AuthenticationHelper(ta, ca);
            eac2Output = auth.performAuth(eac2Output, internalData);
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac2Output.getAuthDataType());
        }
        catch (ParserConfigurationException | ProtocolException | TLVException e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        Promise<Object> p = dynCtx.getPromise("processing_canceled");
        if (p.derefNonblocking() == null) {
            dynCtx.put("org.openecard.tr03112.eac.authentication_done", true);
            return response;
        }
        dynCtx.put("org.openecard.tr03112.eac.authentication_done", false);
        response = new DIDAuthenticateResponse();
        String msg = "Authentication canceled by the user.";
        response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", msg));
        return response;
    }
}

