/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage.addon;

import java.io.IOException;
import java.util.List;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.addon.manifest.ConfigurationEntry;
import org.openecard.addon.manifest.EnumEntry;
import org.openecard.addon.manifest.EnumListEntry;
import org.openecard.addon.manifest.FileEntry;
import org.openecard.addon.manifest.FileListEntry;
import org.openecard.addon.manifest.ScalarEntry;
import org.openecard.addon.manifest.ScalarEntryType;
import org.openecard.addon.manifest.ScalarListEntry;
import org.openecard.addon.manifest.ScalarListEntryType;
import org.openecard.richclient.gui.manage.Settings;
import org.openecard.richclient.gui.manage.SettingsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSettingsGroup
extends SettingsGroup {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultSettingsGroup.class);
    private static final String LANGUAGE_CODE = System.getProperty("user.language");

    public DefaultSettingsGroup(String title, Settings settings, List<ConfigurationEntry> configEntries) {
        super(title, settings);
        for (ConfigurationEntry entry : configEntries) {
            FileEntry fEntry;
            List<String> values;
            EnumEntry enumEntry;
            String name = entry.getLocalizedName(LANGUAGE_CODE);
            String description = entry.getLocalizedDescription(LANGUAGE_CODE);
            if (ScalarEntry.class.equals(entry.getClass())) {
                ScalarEntry scalarEntry = (ScalarEntry)entry;
                if (scalarEntry.getType().equals(ScalarEntryType.STRING.name())) {
                    this.addInputItem(name, description, entry.getKey());
                    continue;
                }
                if (scalarEntry.getType().equals(ScalarEntryType.BOOLEAN.name())) {
                    this.addBoolItem(name, description, entry.getKey());
                    continue;
                }
                if (scalarEntry.getType().equals(ScalarEntryType.BIGDECIMAL.name())) {
                    this.addScalarEntryTypNumber(name, description, scalarEntry.getKey(), scalarEntry.getType());
                    continue;
                }
                if (scalarEntry.getType().equals(ScalarEntryType.BIGINTEGER.name())) {
                    this.addScalarEntryTypNumber(name, description, scalarEntry.getKey(), scalarEntry.getType());
                    continue;
                }
                logger.error("Untreated ScalarEntry type: {}", (Object)scalarEntry.getType());
                continue;
            }
            if (ScalarListEntry.class.equals(entry.getClass())) {
                this.addScalarListItem(name, description, entry.getKey(), ScalarListEntryType.valueOf(((ScalarListEntry)entry).getType()));
                continue;
            }
            if (EnumEntry.class.equals(entry.getClass())) {
                enumEntry = (EnumEntry)entry;
                values = enumEntry.getValues();
                this.addSelectionItem(name, description, enumEntry.getKey(), values.toArray(new String[values.size()]));
                continue;
            }
            if (EnumListEntry.class.equals(entry.getClass())) {
                enumEntry = (EnumListEntry)entry;
                values = enumEntry.getValues();
                this.addMultiSelectionItem(name, description, entry.getKey(), values);
                continue;
            }
            if (FileEntry.class.equals(entry.getClass())) {
                fEntry = (FileEntry)entry;
                this.addFileEntry(name, description, entry.getKey(), fEntry.getFileType(), fEntry.isRequiredBeforeAction());
                continue;
            }
            if (FileListEntry.class.equals(entry.getClass())) {
                fEntry = (FileListEntry)entry;
                this.addFileListEntry(name, description, entry.getKey(), fEntry.getFileType(), fEntry.isRequiredBeforeAction());
                continue;
            }
            logger.error("Untreated entry type: {}", (Object)entry.getClass().getName());
        }
    }

    @Override
    protected void saveProperties() throws IOException, SecurityException, AddonPropertiesException {
        super.saveProperties();
    }
}

