/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.addon.AddonException;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonProperties;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.richclient.gui.manage.AboutPanel;
import org.openecard.richclient.gui.manage.ActionEntryPanel;
import org.openecard.richclient.gui.manage.ActionPanel;
import org.openecard.richclient.gui.manage.AddonPanel;
import org.openecard.richclient.gui.manage.AddonSelectionModel;
import org.openecard.richclient.gui.manage.Settings;
import org.openecard.richclient.gui.manage.SettingsFactory;
import org.openecard.richclient.gui.manage.addon.DefaultSettingsGroup;
import org.openecard.richclient.gui.manage.addon.DefaultSettingsPanel;
import org.openecard.richclient.gui.manage.core.ConnectionSettingsAddon;
import org.openecard.richclient.gui.manage.core.GeneralSettingsAddon;
import org.openecard.richclient.gui.manage.core.LogSettingsAddon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE_CODE = System.getProperty("user.language");
    private static final Logger logger = LoggerFactory.getLogger(ManagementDialog.class);
    private static ManagementDialog runningDialog;
    private final I18n lang = I18n.getTranslation("addon");
    private final AddonManager manager;
    private final AddonRegistry cpReg;
    private final AddonRegistry fileReg;
    private final JPanel selectionPanel;
    private final JPanel contentPane;
    private JList coreList;
    private JList addonList;
    private final JPanel addonPanel;
    private JLabel lastImage;

    public static synchronized void showDialog(AddonManager manager) {
        if (runningDialog == null) {
            logger.debug("Creating ManagementDialog.");
            ManagementDialog dialog = new ManagementDialog(manager);
            dialog.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    runningDialog = null;
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            logger.debug("Displaying ManagementDialog.");
            dialog.setVisible(true);
            runningDialog = dialog;
        } else {
            logger.debug("Not displaying ManagementDialog.");
            runningDialog.toFront();
        }
    }

    public ManagementDialog(AddonManager manager) {
        logger.debug("Creating ManagementDialog.");
        this.manager = manager;
        this.cpReg = manager.getBuiltinRegistry();
        this.fileReg = manager.getExternalRegistry();
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setIconImage(logo);
        this.setTitle(this.lang.translationForKey("addon.title", AppVersion.getName()));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(640, 420));
        this.setSize(780, 480);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.addonPanel = new JPanel(new BorderLayout(), true);
        this.contentPane.add((Component)this.addonPanel, "Center");
        JPanel selectionWrapper = new JPanel(new BorderLayout());
        this.contentPane.add((Component)selectionWrapper, "West");
        this.selectionPanel = new JPanel();
        selectionWrapper.add((Component)this.selectionPanel, "North");
        selectionWrapper.add(Box.createHorizontalGlue(), "Center");
        GridBagLayout selectionLayout = new GridBagLayout();
        selectionLayout.rowHeights = new int[]{0, 0, 0, 0};
        selectionLayout.columnWeights = new double[]{1.0};
        selectionLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        this.selectionPanel.setLayout(selectionLayout);
        logger.debug("Creating core list.");
        this.createCoreList();
        logger.debug("Creating addon list.");
        this.createAddonList();
        logger.debug("Setup core list.");
        this.setupCoreList();
        logger.debug("Setup addon list.");
        this.setupAddonList();
        this.setLocationRelativeTo(null);
        logger.debug("Finished creating ManagementDialog.");
    }

    public void setLogo(@Nonnull Image logo) {
        if (this.lastImage != null) {
            this.selectionPanel.remove(this.lastImage);
        }
        this.lastImage = new JLabel(new ImageIcon(logo));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 6, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.selectionPanel.add((Component)this.lastImage, labelConstraints);
        this.selectionPanel.revalidate();
        this.selectionPanel.repaint();
    }

    private void createCoreList() {
        JLabel label = new JLabel(this.lang.translationForKey("addon.list.core", AppVersion.getName()));
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.coreList = new JList();
        this.coreList.setFont(this.coreList.getFont().deriveFont(0));
        this.coreList.setSelectionMode(0);
        GridBagConstraints coreListConstraints = new GridBagConstraints();
        coreListConstraints.fill = 2;
        coreListConstraints.insets = new Insets(0, 5, 5, 10);
        coreListConstraints.anchor = 11;
        coreListConstraints.gridx = 0;
        coreListConstraints.gridy = 2;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.coreList.setModel(model);
        this.coreList.addListSelectionListener(model);
        this.addWindowListener(model);
        model.addElement(this.lang.translationForKey("addon.list.core.general", new Object[0]), new GeneralSettingsAddon());
        model.addElement(this.lang.translationForKey("addon.list.core.connection", new Object[0]), new ConnectionSettingsAddon());
        model.addElement(this.lang.translationForKey("addon.list.core.logging", new Object[0]), new LogSettingsAddon());
        for (AddonSpecification desc : this.cpReg.listAddons()) {
            this.createAddonPaneFromAddonSpec(desc, model, true);
        }
        this.selectionPanel.add((Component)this.coreList, coreListConstraints);
    }

    private static Image loadLogo(ClassLoader loader, String logoPath) {
        if (logoPath == null || logoPath.isEmpty()) {
            return null;
        }
        try {
            InputStream in = loader == null ? FileUtils.resolveResourceAsStream(ManagementDialog.class, logoPath) : FileUtils.resolveResourceAsStream(loader, logoPath);
            ImageIcon icon = new ImageIcon(FileUtils.toByteArray(in));
            if (icon.getIconHeight() < 0 || icon.getIconWidth() < 0) {
                return null;
            }
            return icon.getImage();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void createAddonList() {
        JLabel label = new JLabel(this.lang.translationForKey("addon.list.addon", new Object[0]));
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 3;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.addonList = new JList();
        this.addonList.setFont(this.addonList.getFont().deriveFont(0));
        this.addonList.setSelectionMode(0);
        GridBagConstraints addonListConstraints = new GridBagConstraints();
        addonListConstraints.fill = 2;
        addonListConstraints.insets = new Insets(0, 5, 5, 10);
        addonListConstraints.anchor = 11;
        addonListConstraints.gridx = 0;
        addonListConstraints.gridy = 4;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.addonList.setModel(model);
        this.addonList.addListSelectionListener(model);
        this.addWindowListener(model);
        for (AddonSpecification desc : this.fileReg.listAddons()) {
            this.createAddonPaneFromAddonSpec(desc, model, false);
        }
        this.selectionPanel.add((Component)this.addonList, addonListConstraints);
    }

    private void setupCoreList() {
        this.coreList.addListSelectionListener(new ClearSelectionListener(this.addonList));
        this.coreList.setSelectedIndex(0);
    }

    private void setupAddonList() {
        this.addonList.addListSelectionListener(new ClearSelectionListener(this.coreList));
    }

    protected void updateGui() {
        this.selectionPanel.removeAll();
        this.createCoreList();
        this.createAddonList();
        this.coreList.setSelectedIndex(0);
    }

    /*
     * WARNING - void declaration
     */
    private void createAddonPaneFromAddonSpec(AddonSpecification desc, AddonSelectionModel model, boolean coreAddon) {
        void var15_30;
        DefaultSettingsGroup group;
        Image logo;
        String description = desc.getLocalizedDescription(LANGUAGE_CODE);
        String name = desc.getLocalizedName(LANGUAGE_CODE);
        if (coreAddon) {
            logo = ManagementDialog.loadLogo(null, desc.getLogo());
        } else {
            try {
                ClassLoader loader = this.manager.getRegistry().downloadAddon(desc);
                logo = ManagementDialog.loadLogo(loader, "META-INF/" + desc.getLogo());
            }
            catch (AddonException ex) {
                logger.error("Failed to load logo from Add-on bundle.");
                logo = null;
            }
        }
        String about = desc.getAbout(LANGUAGE_CODE);
        String licenseText = desc.getLicenseText(LANGUAGE_CODE);
        AboutPanel aboutPanel = null;
        if (!(about.equals("") && licenseText.equals("") || coreAddon)) {
            aboutPanel = new AboutPanel(desc, coreAddon, this.manager, this);
        }
        DefaultSettingsPanel settingsPanel = null;
        ArrayList<Object> settingsGroups = new ArrayList<Object>();
        AddonProperties addonProps = new AddonProperties(desc);
        Settings settings = SettingsFactory.getInstance(addonProps);
        if (desc.getConfigDescription() != null && !desc.getConfigDescription().getEntries().isEmpty()) {
            Iterator<ProtocolPluginSpecification> group2 = new DefaultSettingsGroup(this.lang.translationForKey("addon.settings.general", new Object[0]), settings, desc.getConfigDescription().getEntries());
            settingsGroups.add(group2);
        }
        if (!desc.getApplicationActions().isEmpty()) {
            for (AppExtensionSpecification appExtensionSpecification : desc.getApplicationActions()) {
                if (appExtensionSpecification.getConfigDescription() == null || appExtensionSpecification.getConfigDescription().getEntries().isEmpty()) continue;
                group = new DefaultSettingsGroup(appExtensionSpecification.getLocalizedName(LANGUAGE_CODE) + " " + this.lang.translationForKey("addon.settings.settings", new Object[0]), settings, appExtensionSpecification.getConfigDescription().getEntries());
                settingsGroups.add(group);
            }
        }
        if (!desc.getBindingActions().isEmpty()) {
            for (AppPluginSpecification appPluginSpecification : desc.getBindingActions()) {
                if (appPluginSpecification.getConfigDescription() == null || appPluginSpecification.getConfigDescription().getEntries().isEmpty()) continue;
                group = new DefaultSettingsGroup(appPluginSpecification.getLocalizedName(LANGUAGE_CODE) + " " + this.lang.translationForKey("addon.settings.settings", new Object[0]), settings, appPluginSpecification.getConfigDescription().getEntries());
                settingsGroups.add(group);
            }
        }
        if (!desc.getIfdActions().isEmpty()) {
            for (ProtocolPluginSpecification protocolPluginSpecification : desc.getIfdActions()) {
                if (protocolPluginSpecification.getConfigDescription() == null || protocolPluginSpecification.getConfigDescription().getEntries().isEmpty()) continue;
                group = new DefaultSettingsGroup(protocolPluginSpecification.getLocalizedName(LANGUAGE_CODE) + " " + this.lang.translationForKey("addon.settings.settings", new Object[0]), settings, protocolPluginSpecification.getConfigDescription().getEntries());
                settingsGroups.add(group);
            }
        }
        if (!desc.getSalActions().isEmpty()) {
            for (ProtocolPluginSpecification protocolPluginSpecification : desc.getSalActions()) {
                if (protocolPluginSpecification.getConfigDescription() == null || protocolPluginSpecification.getConfigDescription().getEntries().isEmpty()) continue;
                group = new DefaultSettingsGroup(protocolPluginSpecification.getLocalizedName(LANGUAGE_CODE) + " " + this.lang.translationForKey("addon.settings.settings", new Object[0]), settings, protocolPluginSpecification.getConfigDescription().getEntries());
                settingsGroups.add(group);
            }
        }
        if (!settingsGroups.isEmpty()) {
            settingsPanel = new DefaultSettingsPanel(settingsGroups.toArray(new DefaultSettingsGroup[settingsGroups.size()]));
        }
        ActionPanel actionPanel = null;
        if (!desc.getApplicationActions().isEmpty()) {
            actionPanel = new ActionPanel();
            for (AppExtensionSpecification appExtSpec : desc.getApplicationActions()) {
                ActionEntryPanel entry = new ActionEntryPanel(desc, appExtSpec, this.manager);
                actionPanel.addActionEntry(entry);
            }
        }
        Object var15_25 = null;
        if (actionPanel != null && settingsPanel == null && aboutPanel == null) {
            AddonPanel addonPanel = new AddonPanel(actionPanel, name, description, logo);
        } else if (actionPanel == null && settingsPanel != null && aboutPanel == null) {
            AddonPanel addonPanel = new AddonPanel(settingsPanel, name, description, logo);
        } else if (actionPanel == null && settingsPanel == null && aboutPanel != null) {
            AddonPanel addonPanel = new AddonPanel(aboutPanel, name, description, logo);
        } else if (actionPanel != null || settingsPanel != null || aboutPanel != null) {
            AddonPanel addonPanel = new AddonPanel(actionPanel, settingsPanel, aboutPanel, name, description, logo);
        }
        if (var15_30 != null) {
            model.addElement(name, (AddonPanel)var15_30);
        }
    }

    private class ClearSelectionListener
    implements ListSelectionListener {
        private final JList otherList;

        public ClearSelectionListener(JList otherList) {
            this.otherList = otherList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object source;
            if (this.otherList != null && (source = e.getSource()) instanceof JComponent) {
                JComponent component = (JComponent)source;
                if (!e.getValueIsAdjusting() && component.hasFocus()) {
                    this.otherList.clearSelection();
                }
            }
        }
    }
}

