/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openecard.common.I18n;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.richclient.gui.components.OpenFileBrowserListener;
import org.openecard.richclient.gui.manage.Settings;

public class FileListEntryItem
extends JPanel {
    private static final Icon openedIndicator = GUIDefaults.getImage("ToggleText.selectedIcon");
    private static final Icon closedIndicator = GUIDefaults.getImage("ToggleText.icon");
    private final I18n lang = I18n.getTranslation("addon");
    private final ArrayList<String> entries = new ArrayList();
    private final ArrayList<JButton> entryPlusBox = new ArrayList();
    private final ArrayList<JTextField> textEntries = new ArrayList();
    private final String fileType;
    private final String property;
    private final Settings properties;
    private int currentYCoordinate = 0;

    public FileListEntryItem(String fileType, String property, Settings properties) {
        this.setLayout(new GridBagLayout());
        this.fileType = fileType;
        this.properties = properties;
        this.property = property;
        String props = properties.getProperty(property);
        if (props != null && !props.equals("")) {
            for (String entry : props.split(";")) {
                this.entries.add(entry);
                this.addRow(entry);
            }
        } else {
            this.addEmptyEntry();
        }
    }

    private void addEmptyEntry() {
        this.addRow(null);
    }

    private void rebuild() {
        this.removeAll();
        this.textEntries.clear();
        this.entryPlusBox.clear();
        if (!this.entries.isEmpty()) {
            for (String entry : this.entries) {
                this.addRow(entry);
            }
        } else {
            this.addEmptyEntry();
        }
        this.revalidate();
        this.repaint();
    }

    private void addRow(String entry) {
        JTextField textField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        textField.setText(entry);
        textField.setToolTipText(textField.getText());
        textField.getDocument().addDocumentListener(new DocumentChangeListener(textField));
        this.textEntries.add(textField);
        JButton browseButton = new JButton(this.lang.translationForKey("addon.settings.browse", new Object[0]));
        browseButton.addActionListener(new OpenFileBrowserListener(this.fileType, textField));
        if (!this.entryPlusBox.isEmpty()) {
            JButton prevPlus = this.entryPlusBox.get(this.entryPlusBox.size() - 1);
            prevPlus.setVisible(false);
        }
        JButton plus = new JButton();
        plus.setIcon(closedIndicator);
        plus.addActionListener(new AddActionListener(plus));
        plus.setOpaque(true);
        plus.setFocusPainted(false);
        plus.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        plus.setHorizontalAlignment(2);
        plus.setMargin(new Insets(0, 0, 0, 0));
        plus.setBounds(0, 0, 0, 0);
        plus.setContentAreaFilled(false);
        plus.setHorizontalTextPosition(11);
        this.entryPlusBox.add(plus);
        JButton minus = new JButton();
        minus.setIcon(openedIndicator);
        minus.addActionListener(new RemoveActionListener(minus));
        minus.setName(entry);
        minus.setOpaque(true);
        minus.setFocusPainted(false);
        minus.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        minus.setHorizontalAlignment(2);
        minus.setMargin(new Insets(0, 0, 0, 0));
        minus.setBounds(0, 0, 0, 0);
        minus.setContentAreaFilled(false);
        minus.setHorizontalTextPosition(11);
        GridBagConstraints textConstraint = new GridBagConstraints();
        textConstraint.anchor = 17;
        textConstraint.fill = 2;
        textConstraint.gridx = 0;
        textConstraint.gridy = this.currentYCoordinate;
        textConstraint.weightx = 4.0;
        GridBagConstraints plusConstraint = new GridBagConstraints();
        plusConstraint.anchor = 17;
        plusConstraint.fill = 0;
        plusConstraint.gridx = 3;
        plusConstraint.gridy = this.currentYCoordinate;
        plusConstraint.gridwidth = 0;
        plusConstraint.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints minusConstraint = new GridBagConstraints();
        minusConstraint.anchor = 17;
        minusConstraint.fill = 0;
        minusConstraint.gridx = 2;
        minusConstraint.gridy = this.currentYCoordinate;
        minusConstraint.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints browseConstrain = new GridBagConstraints();
        browseConstrain.anchor = 17;
        browseConstrain.fill = 0;
        browseConstrain.gridx = 1;
        browseConstrain.gridy = this.currentYCoordinate++;
        browseConstrain.insets = new Insets(5, 5, 0, 5);
        this.add((Component)textField, textConstraint);
        this.add((Component)browseButton, browseConstrain);
        this.add((Component)plus, plusConstraint);
        this.add((Component)minus, minusConstraint);
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private final JTextField textField;
        private String currentText;

        private DocumentChangeListener(JTextField field) {
            this.textField = field;
            this.currentText = field.getText();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.concatContentsAndSetProperty();
            int entryIndex = FileListEntryItem.this.entries.indexOf(this.currentText);
            if (entryIndex >= 0) {
                ((JButton)FileListEntryItem.this.entryPlusBox.get(entryIndex)).setName(this.textField.getText());
                FileListEntryItem.this.entries.set(entryIndex, this.textField.getText());
            } else {
                FileListEntryItem.this.entries.add(this.textField.getText());
            }
            this.currentText = this.textField.getText();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.concatContentsAndSetProperty();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void concatContentsAndSetProperty() {
            StringBuilder sb = new StringBuilder();
            for (JTextField text : FileListEntryItem.this.textEntries) {
                File file = new File(text.getText());
                if (!file.exists() || !file.isFile()) continue;
                sb.append(text.getText());
                sb.append(";");
            }
            FileListEntryItem.this.properties.setProperty(FileListEntryItem.this.property, sb.toString());
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private final JButton button;

        private RemoveActionListener(JButton removeButton) {
            this.button = removeButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = this.button.getName();
            int indexOfEntry = FileListEntryItem.this.entries.indexOf(name);
            if (indexOfEntry >= 0) {
                FileListEntryItem.this.entryPlusBox.remove(indexOfEntry);
                JTextField field = (JTextField)FileListEntryItem.this.textEntries.get(indexOfEntry);
                field.setText("");
                FileListEntryItem.this.textEntries.remove(indexOfEntry);
                FileListEntryItem.this.entries.remove(name);
            }
            FileListEntryItem.this.rebuild();
        }
    }

    private class AddActionListener
    implements ActionListener {
        private final JButton button;

        private AddActionListener(JButton addButton) {
            this.button = addButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!((JTextField)FileListEntryItem.this.textEntries.get(FileListEntryItem.this.textEntries.size() - 1)).getText().equals("")) {
                this.button.setVisible(false);
                FileListEntryItem.this.addEmptyEntry();
            }
        }
    }
}

