/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfig {
    private static final String CFG_FILENAME = "richclient_logback.xml";
    private static Logger LOG;

    public static File getConfFile() throws IOException {
        File cfgDir = FileUtils.getHomeConfigDir();
        String logFileStr = cfgDir + File.separator + CFG_FILENAME;
        File logFile = new File(logFileStr);
        return logFile;
    }

    public static void load() throws IOException, SecurityException, JoranException {
        File logFile = LogbackConfig.getConfFile();
        if (logFile.canRead() && logFile.isFile()) {
            System.setProperty("logback.configurationFile", logFile.getAbsolutePath());
            LoggerContext ctx = (LoggerContext)LoggerFactory.getILoggerFactory();
            ctx.reset();
            JoranConfigurator conf = new JoranConfigurator();
            conf.setContext(ctx);
            ctx.reset();
            conf.doConfigure(logFile);
            if (LOG == null) {
                LOG = LoggerFactory.getLogger(LogbackConfig.class);
            }
            LOG.info("Configured Logback with config file from: {}", (Object)logFile);
        } else {
            LogbackConfig.loadDefault();
        }
    }

    public static void loadDefault() throws JoranException {
        System.clearProperty("logback.configurationFile");
        LoggerContext ctx = (LoggerContext)LoggerFactory.getILoggerFactory();
        ctx.reset();
        ContextInitializer init = new ContextInitializer(ctx);
        init.autoConfig();
    }
}

