/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.recognition;

import iso.std.iso_iec._24727.tech.schema.BeginTransaction;
import iso.std.iso_iec._24727.tech.schema.BeginTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.CardCall;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DataMaskType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.EndTransaction;
import iso.std.iso_iec._24727.tech.schema.EndTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACDResponse;
import iso.std.iso_iec._24727.tech.schema.GetRecognitionTreeResponse;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.MatchingDataType;
import iso.std.iso_iec._24727.tech.schema.RecognitionTree;
import iso.std.iso_iec._24727.tech.schema.ResponseAPDUType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.RecognitionException;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.MessageDialog;
import org.openecard.gui.UserConsent;
import org.openecard.gui.message.DialogType;
import org.openecard.recognition.RecognitionProperties;
import org.openecard.recognition.staticrepo.LocalCifRepo;
import org.openecard.recognition.statictree.LocalFileTree;
import org.openecard.ws.GetCardInfoOrACD;
import org.openecard.ws.GetRecognitionTree;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardRecognitionImpl
implements CardRecognition {
    private static final Logger LOG = LoggerFactory.getLogger(CardRecognitionImpl.class);
    private static final I18n LANG = I18n.getTranslation("recognition");
    private static final String IMAGE_PROPERTIES = "/card-images/card-images.properties";
    private final FutureTask<RecognitionTree> tree;
    private final FutureTask<GetCardInfoOrACD> cifRepo;
    private final Properties cardImagesMap = new Properties();
    private final Environment env;
    private UserConsent gui;

    public CardRecognitionImpl(Environment env) throws Exception {
        this(env, null, null);
    }

    public CardRecognitionImpl(Environment env, final GetRecognitionTree treeRepo, final GetCardInfoOrACD cifRepo) throws Exception {
        this.env = env;
        this.cardImagesMap.load(FileUtils.resolveResourceAsStream(CardRecognitionImpl.class, IMAGE_PROPERTIES));
        this.cifRepo = new FutureTask<GetCardInfoOrACD>(new Callable<GetCardInfoOrACD>(){

            @Override
            public GetCardInfoOrACD call() throws Exception {
                WSMarshaller cifMarshaller = WSMarshallerFactory.createInstance();
                GetCardInfoOrACD cifRepoTmp = cifRepo;
                if (cifRepoTmp == null) {
                    cifRepoTmp = new LocalCifRepo(cifMarshaller);
                }
                return cifRepoTmp;
            }
        });
        new Thread(this.cifRepo, "Init-CardInfo-Repo").start();
        this.tree = new FutureTask<RecognitionTree>(new Callable<RecognitionTree>(){

            @Override
            public RecognitionTree call() throws Exception {
                WSMarshaller treeMarshaller = WSMarshallerFactory.createInstance();
                GetRecognitionTree treeRepoTmp = treeRepo;
                if (treeRepoTmp == null) {
                    treeRepoTmp = new LocalFileTree(treeMarshaller);
                }
                iso.std.iso_iec._24727.tech.schema.GetRecognitionTree req = new iso.std.iso_iec._24727.tech.schema.GetRecognitionTree();
                req.setAction(RecognitionProperties.getAction());
                GetRecognitionTreeResponse resp = treeRepoTmp.getRecognitionTree(req);
                CardRecognitionImpl.this.checkResult(resp.getResult());
                return resp.getRecognitionTree();
            }
        });
        new Thread(this.tree, "Init-RecognitionTree-Repo").start();
    }

    public void setGUI(UserConsent gui) {
        this.gui = gui;
    }

    private RecognitionTree getTree() {
        try {
            return this.tree.get();
        }
        catch (InterruptedException ex) {
            String msg = "Initialization of the RecognitionTree repository has been interrupted.";
            LOG.warn(msg);
            throw new RuntimeException(msg);
        }
        catch (ExecutionException ex) {
            String msg = "Initialization of the RecognitionTree repository yielded an error.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg, ex.getCause());
        }
    }

    private GetCardInfoOrACD getCifRepo() {
        try {
            return this.cifRepo.get();
        }
        catch (InterruptedException ex) {
            String msg = "Initialization of the CardInfo repository has been interrupted.";
            LOG.warn(msg);
            throw new RuntimeException(msg);
        }
        catch (ExecutionException ex) {
            String msg = "Initialization of the CardInfo repository yielded an error.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg, ex.getCause());
        }
    }

    @Override
    public List<CardInfoType> getCardInfos() {
        iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD req = new iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD();
        req.setAction("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getOtherFiles");
        GetCardInfoOrACDResponse res = this.getCifRepo().getCardInfoOrACD(req);
        List<Serializable> cifs = res.getCardInfoOrCapabilityInfo();
        ArrayList<CardInfoType> result = new ArrayList<CardInfoType>();
        for (Serializable next : cifs) {
            if (!(next instanceof CardInfoType)) continue;
            result.add((CardInfoType)next);
        }
        return result;
    }

    @Override
    public CardInfoType getCardInfo(String type) {
        CardInfoType cif = this.env.getCIFProvider().getCardInfo(type);
        if (cif == null && this.cifRepo != null) {
            iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD req = new iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD();
            req.setAction("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getSpecifiedFile");
            req.getCardTypeIdentifier().add(type);
            GetCardInfoOrACDResponse res = this.getCifRepo().getCardInfoOrACD(req);
            List<Serializable> cifs = res.getCardInfoOrCapabilityInfo();
            for (Serializable next : cifs) {
                if (!(next instanceof CardInfoType)) continue;
                return (CardInfoType)next;
            }
        }
        return cif;
    }

    @Override
    public String getTranslatedCardName(String cardType) {
        CardInfoType info = this.getCardInfo(cardType);
        Locale userLocale = Locale.getDefault();
        String langCode = userLocale.getLanguage();
        String enFallback = "Unknown card type.";
        if (info == null) {
            return enFallback;
        }
        for (InternationalStringType typ : info.getCardType().getCardTypeName()) {
            if (typ.getLang().equalsIgnoreCase("en")) {
                enFallback = typ.getValue();
            }
            if (!typ.getLang().equalsIgnoreCase(langCode)) continue;
            return typ.getValue();
        }
        return enFallback;
    }

    @Override
    public InputStream getCardImage(String objectid) {
        String fname = this.cardImagesMap.getProperty(objectid);
        InputStream fs = this.env.getCIFProvider().getCardImage(objectid);
        if (fs == null && fname != null) {
            fs = CardRecognitionImpl.loadCardImage(fname);
        }
        if (fs == null) {
            fs = this.getUnknownCardImage();
        }
        return fs;
    }

    @Override
    public InputStream getUnknownCardImage() {
        return CardRecognitionImpl.loadCardImage("unknown_card.png");
    }

    @Override
    public InputStream getNoCardImage() {
        return CardRecognitionImpl.loadCardImage("no_card.jpg");
    }

    @Override
    public InputStream getNoTerminalImage() {
        return CardRecognitionImpl.loadCardImage("no_terminal.png");
    }

    private static InputStream loadCardImage(String filename) {
        try {
            return FileUtils.resolveResourceAsStream(CardRecognitionImpl.class, "/card-images/" + filename);
        }
        catch (IOException ex) {
            LOG.info("Failed to load card image '" + filename + "'.", ex);
            return null;
        }
    }

    @Override
    @Nullable
    public ConnectionHandleType.RecognitionInfo recognizeCard(byte[] ctx, String ifdName, BigInteger slot) throws RecognitionException {
        byte[] slotHandle = this.connect(ctx, ifdName, slot);
        String type = this.treeCalls(slotHandle, this.getTree().getCardCall());
        this.disconnect(slotHandle);
        if (type == null) {
            return null;
        }
        ConnectionHandleType.RecognitionInfo info = new ConnectionHandleType.RecognitionInfo();
        info.setCardType(type);
        return info;
    }

    private void checkResult(Result r) throws RecognitionException {
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            throw new RecognitionException(r);
        }
    }

    private boolean checkTransmitResult(TransmitResponse r) {
        return !r.getOutputAPDU().isEmpty() && r.getOutputAPDU().get(0).length >= 2;
    }

    private long fibonacci(int idx) {
        if (idx == 1 || idx == 2) {
            return 1L;
        }
        return this.fibonacci(idx - 1) + this.fibonacci(idx - 2);
    }

    private byte[] connect(byte[] ctx, String ifdName, BigInteger slot) throws RecognitionException {
        Connect c = new Connect();
        c.setContextHandle(ctx);
        c.setIFDName(ifdName);
        c.setSlot(slot);
        ConnectResponse r = (ConnectResponse)this.env.getDispatcher().safeDeliver(c);
        this.checkResult(r.getResult());
        this.waitForExclusiveCardAccess(r.getSlotHandle(), ifdName);
        return r.getSlotHandle();
    }

    private void waitForExclusiveCardAccess(byte[] slotHandle, String ifdName) throws RecognitionException {
        String resultMajor;
        int i = 2;
        do {
            BeginTransaction trans = new BeginTransaction();
            trans.setSlotHandle(slotHandle);
            BeginTransactionResponse resp = (BeginTransactionResponse)this.env.getDispatcher().safeDeliver(trans);
            resultMajor = resp.getResult().getResultMajor();
            if (resultMajor.equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok")) continue;
            String resultMinor = resp.getResult().getResultMinor();
            if ("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle".equals(resultMinor)) {
                throw new RecognitionException("Card is not available anymore.");
            }
            try {
                long waitInSeconds = this.fibonacci(i);
                LOG.debug("Could not get exclusive card access. Trying again in {} seconds.", (Object)waitInSeconds);
                if (++i == 6 && this.gui != null) {
                    MessageDialog dialog = this.gui.obtainMessageDialog();
                    String message = LANG.translationForKey("message", AppVersion.getName(), ifdName);
                    String title = LANG.translationForKey("error", ifdName);
                    dialog.showMessageDialog(message, title, DialogType.WARNING_MESSAGE);
                }
                Thread.sleep(1000L * waitInSeconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!resultMajor.equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok"));
    }

    private void disconnect(byte[] slotHandle) throws RecognitionException {
        EndTransaction end = new EndTransaction();
        end.setSlotHandle(slotHandle);
        EndTransactionResponse endTransactionResponse = (EndTransactionResponse)this.env.getDispatcher().safeDeliver(end);
        this.checkResult(endTransactionResponse.getResult());
        Disconnect d = new Disconnect();
        d.setSlotHandle(slotHandle);
        DisconnectResponse r = (DisconnectResponse)this.env.getDispatcher().safeDeliver(d);
        this.checkResult(r.getResult());
    }

    private byte[] transmit(byte[] slotHandle, byte[] input, List<ResponseAPDUType> results) {
        Transmit t = new Transmit();
        t.setSlotHandle(slotHandle);
        InputAPDUInfoType apdu = new InputAPDUInfoType();
        apdu.setInputAPDU(input);
        for (ResponseAPDUType result : results) {
            apdu.getAcceptableStatusCode().add(result.getTrailer());
        }
        t.getInputAPDUInfo().add(apdu);
        TransmitResponse r = (TransmitResponse)this.env.getDispatcher().safeDeliver(t);
        if (this.checkTransmitResult(r)) {
            return r.getOutputAPDU().get(0);
        }
        return null;
    }

    private List<CardCall> branch2list(CardCall first) {
        LinkedList<CardCall> calls = new LinkedList<CardCall>();
        calls.add(first);
        CardCall next = first;
        while (next.getResponseAPDU().get(0).getBody() == null) {
            next = next.getResponseAPDU().get(0).getConclusion().getCardCall().get(0);
            calls.add(next);
        }
        return calls;
    }

    private String treeCalls(byte[] slotHandle, List<CardCall> calls) throws RecognitionException {
        block0: for (CardCall c : calls) {
            List<CardCall> branch = this.branch2list(c);
            for (CardCall next : branch) {
                boolean matcher = next.getResponseAPDU().get(0).getBody() != null;
                byte[] resultBytes = this.transmit(slotHandle, next.getCommandAPDU(), next.getResponseAPDU());
                if (resultBytes == null) continue block0;
                byte[] result = CardResponseAPDU.getData(resultBytes);
                byte[] trailer = CardResponseAPDU.getTrailer(resultBytes);
                if (!matcher && !Arrays.equals(next.getResponseAPDU().get(0).getTrailer(), trailer)) continue block0;
                if (!matcher) continue;
                for (ResponseAPDUType r : next.getResponseAPDU()) {
                    if (!Arrays.equals(r.getTrailer(), trailer) || !this.checkBody(r.getBody(), result)) continue;
                    if (r.getConclusion().getRecognizedCardType() != null) {
                        return r.getConclusion().getRecognizedCardType();
                    }
                    return this.treeCalls(slotHandle, r.getConclusion().getCardCall());
                }
            }
        }
        return null;
    }

    private boolean checkBody(DataMaskType body, byte[] result) {
        if (body.getTag() != null && body.getDataObject() != null) {
            byte[] tag = body.getTag();
            if (ByteUtils.isPrefix(tag, result)) {
                result = ByteUtils.copy(result, tag.length, result.length - tag.length);
                return this.checkDataObject(body.getDataObject(), result);
            }
            return false;
        }
        if (body.getDataObject() != null) {
            return this.checkDataObject(body.getDataObject(), result);
        }
        return this.checkMatchingData(body.getMatchingData(), result);
    }

    private boolean checkDataObject(DataMaskType matcher, byte[] result) {
        if (matcher.getTag() != null && matcher.getDataObject() != null) {
            try {
                TLV tlv = TLV.fromBER(result);
                return this.checkDataObject(matcher, tlv);
            }
            catch (TLVException tLVException) {
                return false;
            }
        }
        return this.checkMatchingData(matcher.getMatchingData(), result);
    }

    private boolean checkDataObject(DataMaskType matcher, TLV result) {
        byte[] tag = matcher.getTag();
        DataMaskType nextMatcher = matcher.getDataObject();
        if (tag == null || nextMatcher == null) {
            return false;
        }
        long tagNum = ByteUtils.toLong(tag);
        List<TLV> chunks = result.findNextTags(tagNum);
        for (TLV next : chunks) {
            boolean outcome = nextMatcher.getMatchingData() != null ? this.checkMatchingData(nextMatcher.getMatchingData(), next.getValue()) : this.checkDataObject(nextMatcher, next.getChild());
            if (!outcome) continue;
            return true;
        }
        return false;
    }

    private boolean checkMatchingData(MatchingDataType matcher, byte[] result) {
        int i;
        byte[] offsetBytes = matcher.getOffset();
        byte[] lengthBytes = matcher.getLength();
        byte[] valueBytes = matcher.getMatchingValue();
        byte[] maskBytes = matcher.getMask();
        if (offsetBytes == null) {
            offsetBytes = new byte[]{0, 0};
        }
        int offset = ByteUtils.toInteger(offsetBytes);
        int length = ByteUtils.toInteger(lengthBytes);
        if (maskBytes == null) {
            maskBytes = new byte[valueBytes.length];
            for (i = 0; i < maskBytes.length; ++i) {
                maskBytes[i] = -1;
            }
        }
        if (maskBytes.length != valueBytes.length) {
            return false;
        }
        if (valueBytes.length != length) {
            return false;
        }
        if (result.length < length + offset) {
            return false;
        }
        for (i = offset; i < length + offset; ++i) {
            if ((maskBytes[i - offset] & result[i]) == valueBytes[i - offset]) continue;
            return false;
        }
        return true;
    }
}

