/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PUKStepAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(PUKStepAction.class);
    private static final String PIN_ID_PUK = "4";
    private final boolean capturePin;
    private final byte[] slotHandle;
    private final Dispatcher dispatcher;
    private String puk;

    public PUKStepAction(boolean capturePin, byte[] slotHandle, Dispatcher dispatcher, Step step) {
        super(step);
        this.capturePin = capturePin;
        this.slotHandle = slotHandle;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        AuthDataMap tmp;
        if (result.isBack()) {
            return new StepActionResult(StepActionResultStatus.BACK);
        }
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            tmp = new AuthDataMap(paceInput);
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Failed to read empty Protocol data.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            if (!this.verifyUserInput(executionResults)) {
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            paceInputMap.addElement("PIN", this.puk);
        }
        paceInputMap.addElement("PinID", PIN_ID_PUK);
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.slotHandle);
        establishChannel.setAuthenticationProtocolData(paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            EstablishChannelResponse establishChannelResponse = (EstablishChannelResponse)this.dispatcher.safeDeliver(establishChannel);
            WSHelper.checkResult(establishChannelResponse);
            StepActionResult stepActionResult = new StepActionResult(StepActionResultStatus.NEXT);
            return stepActionResult;
        }
        catch (WSHelper.WSException ex) {
            LOG.info("Wrong PUK entered, trying again");
            StepActionResult stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT);
            return stepActionResult;
        }
        finally {
            DestroyChannel destroyChannel = new DestroyChannel();
            destroyChannel.setSlotHandle(this.slotHandle);
            this.dispatcher.safeDeliver(destroyChannel);
        }
    }

    private boolean verifyUserInput(ExecutionResults executionResults) {
        PasswordField pukField = (PasswordField)executionResults.getResult("PUK_FIELD");
        this.puk = new String(pukField.getValue());
        return !this.puk.isEmpty();
    }
}

