/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.GenericPINAction;
import org.openecard.plugins.pinplugin.gui.GenericPINStep;

public class PINDialog {
    private final UserConsent gui;
    private final ConnectionHandleType conHandle;
    private final RecognizedState state;
    private final boolean capturePin;
    private final Dispatcher dispatcher;

    public PINDialog(UserConsent gui, Dispatcher dispatcher, ConnectionHandleType cHandle, RecognizedState pinState, boolean capturePin) {
        this.gui = gui;
        this.conHandle = cHandle;
        this.state = pinState;
        this.capturePin = capturePin;
        this.dispatcher = dispatcher;
    }

    public void show() {
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createUserConsentDescription());
        ExecutionEngine exec = new ExecutionEngine(ucr);
        exec.process();
    }

    private UserConsentDescription createUserConsentDescription() {
        UserConsentDescription uc = new UserConsentDescription("PIN Operation", "pin_entry_dialog");
        GenericPINStep gPINStep = new GenericPINStep("GenericPINStepID", "GenericPINStep", this.capturePin, this.state);
        gPINStep.setAction(new GenericPINAction("PIN Management", this.state, this.conHandle, this.dispatcher, gPINStep, this.capturePin));
        uc.getSteps().add(gPINStep);
        return uc;
    }
}

