/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.plugins.pinplugin.RecognizedState;

public class GenericPINStep
extends Step {
    private final boolean capturePin;
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String CHANGE_PIN_TITLE = "action.changepin.userconsent.pinstep.title";
    private static final String PINSTEP_NEWPINREPEAT = "action.changepin.userconsent.pinstep.newpinrepeat";
    private static final String PINSTEP_NEWPIN = "action.changepin.userconsent.pinstep.newpin";
    private static final String PINSTEP_OLDPIN = "action.changepin.userconsent.pinstep.oldpin";
    private static final String PINSTEP_DESCRIPTION = "action.changepin.userconsent.pinstep.description";
    private static final String PINSTEP_DESCRIPTION_AFTER_CAN = "action.changepin.userconsent.pinstep.description_after_can";
    private static final String REMAINING_ATTEMPTS = "action.changepin.userconsent.pinstep.remaining_attempts";
    private static final String WRONG_ENTRY = "action.changepin.userconsent.pinstep.wrong_entry";
    private static final String INCORRECT_INPUT = "action.changepin.userconsent.pinstep.incorrect_input";
    private static final String PINSTEP_NATIV_CHANGE_DESCRIPTION = "action.changepin.userconsent.pinstep.native_start_description";
    private static final String PINSTEP_NATIV_CHANGE_DESCRIPTION_AFTER_CAN = "action.changepin.userconsent.pinstep.native_start_description_after_can";
    private static final String PUKSTEP_DESCRIPTION = "action.unblockpin.userconsent.pukstep.description";
    private static final String PUKSTEP_TITLE = "action.unblockpin.userconsent.pukstep.title";
    private static final String PUKSTEP_PUK = "action.unblockpin.userconsent.pukstep.puk";
    private static final String PUKSTEP_START_NATIV_DESCRIPTION = "action.unblockpin.userconsent.pukstep.nativ_start_description";
    private static final String CANSTEP_TITLE = "action.changepin.userconsent.canstep.title";
    private static final String CANSTEP_NOTICE = "action.changepin.userconsent.canstep.notice";
    private static final String CANSTEP_CAN = "action.changepin.userconsent.canstep.can";
    private static final String CANSTEP_DESCRIPTION = "action.changepin.userconsent.canstep.description";
    private static final String WRONG_CAN = "action.changepin.userconsent.canstepaction.wrong_can";
    private static final String CANSTEP_START_NATIV_DESCRIPTION = "action.changepin.userconsent.canstepaction.nativ_start_description";
    private static final String ERROR_TITLE = "action.changepin.userconsent.errorstep.title";
    private static final String ERRORSTEP_DEACTIVATED = "action.changepin.userconsent.errorstep.deactivated";
    private static final String ERRORSTEP_PUK_BLOCKED = "action.changepin.userconsent.errorstep.puk_blocked";
    private static final String ERRORSTEP_UNKNOWN = "action.changepin.userconsent.errorstep.unknown";
    protected static final String OLD_PIN_FIELD = "OLD_PIN_FIELD";
    protected static final String NEW_PIN_FIELD = "NEW_PIN_FIELD";
    protected static final String NEW_PIN_REPEAT_FIELD = "NEW_PIN_REPEAT_FIELD";
    protected static final String PUK_FIELD = "PUK_FIELD";
    protected static final String CAN_FIELD = "CAN_FIELD";
    private boolean wrongPINFormat;
    private boolean failedPINVerify;
    private boolean wrongCANFormat;
    private boolean failedCANVerify;
    private boolean wrongPUKFormat;
    private boolean failedPUKVerify;
    private boolean canSuccess;
    private int retryCounterPIN;
    private int retryCounterPUK = 10;
    private RecognizedState pinState;

    public GenericPINStep(String id, String title, boolean capturePin, RecognizedState state) {
        super(id, title);
        this.capturePin = capturePin;
        this.pinState = state;
        this.generateGenericGui();
    }

    private void generateGenericGui() {
        switch (this.pinState) {
            case PIN_activated_RC3: {
                this.setTitle(this.lang.translationForKey(CHANGE_PIN_TITLE, new Object[0]));
                this.retryCounterPIN = 3;
                if (this.capturePin) {
                    this.createPINChangeGui();
                    break;
                }
                this.createPINChangeGuiNativ();
                break;
            }
            case PIN_activated_RC2: {
                this.setTitle(this.lang.translationForKey(CHANGE_PIN_TITLE, new Object[0]));
                this.retryCounterPIN = 2;
                if (this.capturePin) {
                    this.createPINChangeGui();
                    break;
                }
                this.createPINChangeGuiNativ();
                break;
            }
            case PIN_blocked: {
                this.setTitle(this.lang.translationForKey(PUKSTEP_TITLE, new Object[0]));
                this.retryCounterPIN = 0;
                if (this.capturePin) {
                    this.createPUKGui();
                    break;
                }
                this.createPUKGuiNativ();
                break;
            }
            case PIN_suspended: {
                this.setTitle(this.lang.translationForKey(CANSTEP_TITLE, new Object[0]));
                this.retryCounterPIN = 1;
                if (this.capturePin) {
                    this.createCANGui();
                    break;
                }
                this.createCANGuiNativ();
                break;
            }
            case PIN_resumed: {
                this.setTitle(this.lang.translationForKey(CHANGE_PIN_TITLE, new Object[0]));
                this.retryCounterPIN = 1;
                this.canSuccess = true;
                if (this.capturePin) {
                    this.createPINChangeGui();
                    break;
                }
                this.createPINChangeGuiNativ();
                break;
            }
            case PIN_deactivated: {
                this.setTitle(this.lang.translationForKey(ERROR_TITLE, new Object[0]));
                this.retryCounterPIN = -1;
                this.createErrorGui();
                break;
            }
            case UNKNOWN: {
                this.setTitle(this.lang.translationForKey(ERROR_TITLE, new Object[0]));
                this.retryCounterPIN = -2;
                this.createErrorGui();
                break;
            }
            case PUK_blocked: {
                this.setTitle(this.lang.translationForKey(ERROR_TITLE, new Object[0]));
                this.createErrorGui();
                this.retryCounterPUK = 0;
            }
        }
    }

    protected void updateState(RecognizedState newState) {
        this.pinState = newState;
        this.getInputInfoUnits().clear();
        this.generateGenericGui();
    }

    private void createPINChangeGuiNativ() {
        String nativPinChangeDescriptionText = this.canSuccess ? this.lang.translationForKey(PINSTEP_NATIV_CHANGE_DESCRIPTION_AFTER_CAN, new Object[0]) : this.lang.translationForKey(PINSTEP_NATIV_CHANGE_DESCRIPTION, new Object[0]);
        Text nativPinChangeDescription = new Text(nativPinChangeDescriptionText);
        this.getInputInfoUnits().add(nativPinChangeDescription);
        if (this.failedPINVerify || this.canSuccess) {
            this.addVerifyFailed("PIN");
        }
        this.addRemainingAttempts();
    }

    private void createPINChangeGui() {
        String pinChangeDescriptionText = this.canSuccess ? this.lang.translationForKey(PINSTEP_DESCRIPTION_AFTER_CAN, "PIN") : this.lang.translationForKey(PINSTEP_DESCRIPTION, "PIN");
        Text pinChangeDescription = new Text(pinChangeDescriptionText);
        this.getInputInfoUnits().add(pinChangeDescription);
        Text dummy = new Text(" ");
        this.getInputInfoUnits().add(dummy);
        Text pinText = new Text(this.lang.translationForKey(PINSTEP_OLDPIN, new Object[0]));
        this.getInputInfoUnits().add(pinText);
        PasswordField oldPIN = new PasswordField(OLD_PIN_FIELD);
        oldPIN.setMinLength(5);
        oldPIN.setMaxLength(6);
        this.getInputInfoUnits().add(oldPIN);
        Text newPinText = new Text(this.lang.translationForKey(PINSTEP_NEWPIN, new Object[0]));
        this.getInputInfoUnits().add(newPinText);
        PasswordField newPIN = new PasswordField(NEW_PIN_FIELD);
        newPIN.setMaxLength(6);
        newPIN.setMinLength(6);
        this.getInputInfoUnits().add(newPIN);
        Text newPinAgainText = new Text(this.lang.translationForKey(PINSTEP_NEWPINREPEAT, new Object[0]));
        this.getInputInfoUnits().add(newPinAgainText);
        PasswordField newPINRepeat = new PasswordField(NEW_PIN_REPEAT_FIELD);
        newPINRepeat.setMaxLength(6);
        newPINRepeat.setMinLength(6);
        this.getInputInfoUnits().add(newPINRepeat);
        if (this.wrongPINFormat) {
            Text noteWrongEntry = new Text();
            noteWrongEntry.setText(this.lang.translationForKey(WRONG_ENTRY, "PIN"));
            this.getInputInfoUnits().add(noteWrongEntry);
        }
        if (this.failedPINVerify) {
            this.addVerifyFailed("PIN");
        }
        this.addRemainingAttempts();
    }

    private void createPUKGuiNativ() {
        Text nativPUKText = new Text(this.lang.translationForKey(PUKSTEP_START_NATIV_DESCRIPTION, new Object[0]));
        this.getInputInfoUnits().add(nativPUKText);
        if (this.failedPUKVerify) {
            this.addVerifyFailed("PUK");
        }
    }

    private void createPUKGui() {
        Text i1 = new Text();
        this.getInputInfoUnits().add(i1);
        i1.setText(this.lang.translationForKey(PUKSTEP_DESCRIPTION, new Object[0]));
        PasswordField pukField = new PasswordField(PUK_FIELD);
        pukField.setMaxLength(10);
        pukField.setMinLength(10);
        pukField.setDescription(this.lang.translationForKey(PUKSTEP_PUK, new Object[0]));
        this.getInputInfoUnits().add(pukField);
        if (this.wrongPUKFormat) {
            Text noteWrongEntry = new Text();
            noteWrongEntry.setText(this.lang.translationForKey(WRONG_ENTRY, "PUK"));
            this.getInputInfoUnits().add(noteWrongEntry);
        }
        if (this.failedPUKVerify) {
            this.addVerifyFailed("PUK");
        }
    }

    private void createCANGuiNativ() {
        Text nativCANText = new Text(this.lang.translationForKey(CANSTEP_START_NATIV_DESCRIPTION, new Object[0]));
        this.getInputInfoUnits().add(nativCANText);
        if (this.failedCANVerify) {
            this.addVerifyFailed("CAN");
        }
    }

    private void createCANGui() {
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey(CANSTEP_NOTICE, new Object[0]));
        this.getInputInfoUnits().add(i1);
        Text i2 = new Text();
        this.getInputInfoUnits().add(i2);
        i2.setText(this.lang.translationForKey(CANSTEP_DESCRIPTION, new Object[0]));
        PasswordField canField = new PasswordField(CAN_FIELD);
        canField.setMinLength(6);
        canField.setMaxLength(6);
        canField.setDescription(this.lang.translationForKey(CANSTEP_CAN, new Object[0]));
        this.getInputInfoUnits().add(canField);
        if (this.wrongCANFormat) {
            Text retryText = new Text();
            retryText.setText(this.lang.translationForKey(WRONG_CAN, new Object[0]));
            this.getInputInfoUnits().add(retryText);
        }
        if (this.failedCANVerify) {
            this.addVerifyFailed("CAN");
        }
    }

    private void createErrorGui() {
        this.setReversible(false);
        Text errorText = new Text();
        switch (this.pinState) {
            case PIN_deactivated: {
                errorText.setText(this.lang.translationForKey(ERRORSTEP_DEACTIVATED, new Object[0]));
                break;
            }
            case PUK_blocked: {
                errorText.setText(this.lang.translationForKey(ERRORSTEP_PUK_BLOCKED, new Object[0]));
                break;
            }
            case UNKNOWN: {
                errorText.setText(this.lang.translationForKey(ERRORSTEP_UNKNOWN, new Object[0]));
            }
        }
        this.getInputInfoUnits().add(errorText);
    }

    protected void setWrongPINFormat(boolean wrongFormat) {
        this.wrongPINFormat = wrongFormat;
    }

    protected void setFailedPINVerify(boolean failedVerify) {
        this.failedPINVerify = failedVerify;
    }

    protected void setWrongCANFormat(boolean wrongFormat) {
        this.wrongCANFormat = wrongFormat;
    }

    protected void setFailedCANVerify(boolean failedVerify) {
        this.failedCANVerify = failedVerify;
    }

    protected void setWrongPUKFormat(boolean wrongFormat) {
        this.wrongPUKFormat = wrongFormat;
    }

    protected void setFailedPUKVerify(boolean failedVerify) {
        this.failedPUKVerify = failedVerify;
    }

    protected void decreasePUKCounter() {
        --this.retryCounterPUK;
        this.getInputInfoUnits().clear();
        this.generateGenericGui();
    }

    private void addRemainingAttempts() {
        Text txtRemainingAttempts = new Text();
        txtRemainingAttempts.setText(this.lang.translationForKey(REMAINING_ATTEMPTS, this.retryCounterPIN));
        this.getInputInfoUnits().add(txtRemainingAttempts);
    }

    private void addVerifyFailed(String did) {
        Text incorrectInput = new Text();
        incorrectInput.setText(this.lang.translationForKey(INCORRECT_INPUT, did));
        this.getInputInfoUnits().add(incorrectInput);
    }
}

