/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ActionType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.ControlIFD;
import iso.std.iso_iec._24727.tech.schema.ControlIFDResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.apdu.ResetRetryCounter;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.AbstractTextField;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.reader.PCSCPinModify;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.GenericPINStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPINAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPINAction.class);
    private static final String PIN_ID_CAN = "2";
    private static final String PIN_ID_PIN = "3";
    private static final String PIN_ID_PUK = "4";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String PUK_SUCCESS = "action.unblockpin.userconsent.pukstep.puk_success";
    private static final String CHANGE_SUCCESS = "action.changepin.userconsent.successstep.description";
    private static final String ERROR_CARD_REMOVED = "action.error.card.removed";
    private static final String ERROR_INTERNAL = "action.error.internal";
    private static final String ERROR_NON_MATCHING_PASSWORDS = "action.error.missing_password_match";
    private static final String ERROR_TIMEOUT = "action.error.timeout";
    private static final String ERROR_TITLE = "action.error.title";
    private static final String ERROR_USER_CANCELLATION_OR_CARD_REMOVED = "action.error.user_cancellation";
    private static final String SUCCESS_TITLE = "action.success.title";
    private static final String ERROR_UNKNOWN = "action.error.unknown";
    private final I18n lang = I18n.getTranslation("pinplugin");
    private final boolean capturePin;
    private final Dispatcher dispatcher;
    private final GenericPINStep gPINStep;
    private ConnectionHandleType cHandle;
    private RecognizedState state;
    private byte[] slotHandle;

    public GenericPINAction(String stepID, RecognizedState state, ConnectionHandleType cHandle, Dispatcher dispatcher, GenericPINStep gPINStep, boolean capturePin) {
        super(gPINStep);
        this.gPINStep = gPINStep;
        this.capturePin = capturePin;
        this.cHandle = cHandle;
        this.dispatcher = dispatcher;
        this.state = state;
        this.slotHandle = cHandle.getSlotHandle();
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        if (result.isCancelled()) {
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        if (this.state != RecognizedState.PIN_resumed) {
            this.updateConnectionHandle();
        }
        switch (this.state) {
            case PIN_activated_RC3: 
            case PIN_activated_RC2: {
                return this.performPINChange(oldResults);
            }
            case PIN_suspended: {
                return this.performResumePIN(oldResults);
            }
            case PIN_resumed: {
                return this.performPINChange(oldResults);
            }
            case PIN_deactivated: {
                return new StepActionResult(StepActionResultStatus.NEXT);
            }
            case PIN_blocked: {
                return this.performUnblockPIN(oldResults);
            }
            case PUK_blocked: {
                return new StepActionResult(StepActionResultStatus.NEXT);
            }
            case UNKNOWN: {
                return new StepActionResult(StepActionResultStatus.NEXT);
            }
        }
        return null;
    }

    private EstablishChannelResponse performPACEWithPIN(Map<String, ExecutionResults> oldResults) throws ParserConfigurationException {
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        AuthDataMap tmp = new AuthDataMap(paceInput);
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField oldPINField = (PasswordField)executionResults.getResult("OLD_PIN_FIELD");
            char[] oldPINValue = oldPINField.getValue();
            if (oldPINValue.length > 6 && oldPINValue.length < 5) {
                return null;
            }
            paceInputMap.addElement("PIN", new String(oldPINValue));
        }
        paceInputMap.addElement("PinID", PIN_ID_PIN);
        EstablishChannel eChannel = this.createEstablishChannelStructure(paceInputMap);
        return (EstablishChannelResponse)this.dispatcher.safeDeliver(eChannel);
    }

    private EstablishChannelResponse performPACEWithCAN(Map<String, ExecutionResults> oldResults) throws ParserConfigurationException {
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        AuthDataMap tmp = new AuthDataMap(paceInput);
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField canField = (PasswordField)executionResults.getResult("CAN_FIELD");
            String canValue = new String(canField.getValue());
            if (canValue.length() != 6) {
                return null;
            }
            paceInputMap.addElement("PIN", canValue);
        }
        paceInputMap.addElement("PinID", PIN_ID_CAN);
        EstablishChannel eChannel = this.createEstablishChannelStructure(paceInputMap);
        return (EstablishChannelResponse)this.dispatcher.safeDeliver(eChannel);
    }

    private EstablishChannelResponse performPACEWithPUK(Map<String, ExecutionResults> oldResults) throws ParserConfigurationException {
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        AuthDataMap tmp = new AuthDataMap(paceInput);
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField pukField = (PasswordField)executionResults.getResult("PUK_FIELD");
            String pukValue = new String(pukField.getValue());
            if (pukValue.length() != 10) {
                return null;
            }
            paceInputMap.addElement("PIN", pukValue);
        }
        paceInputMap.addElement("PinID", PIN_ID_PUK);
        EstablishChannel eChannel = this.createEstablishChannelStructure(paceInputMap);
        return (EstablishChannelResponse)this.dispatcher.safeDeliver(eChannel);
    }

    private EstablishChannel createEstablishChannelStructure(AuthDataResponse paceInputMap) {
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.slotHandle);
        establishChannel.setAuthenticationProtocolData((DIDAuthenticationDataType)paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        return establishChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepActionResult performPINChange(Map<String, ExecutionResults> oldResults) {
        StepActionResult stepActionResult;
        Object disconnect;
        Object newPINField;
        String newPINValue = null;
        String newPINRepeatValue = null;
        if (this.capturePin) {
            try {
                ExecutionResults executionResults = oldResults.get(this.getStepID());
                newPINField = (PasswordField)executionResults.getResult("NEW_PIN_FIELD");
                newPINValue = new String(((AbstractTextField)newPINField).getValue());
                PasswordField newPINRepeatField = (PasswordField)executionResults.getResult("NEW_PIN_REPEAT_FIELD");
                newPINRepeatValue = new String(newPINRepeatField.getValue());
                byte[] pin1 = newPINValue.getBytes(ISO_8859_1);
                byte[] pin2 = newPINRepeatValue.getBytes(ISO_8859_1);
                if (!ByteUtils.compare(pin1, pin2)) {
                    LOG.warn("New PIN does not match the value from the confirmation field.");
                    this.gPINStep.updateState(this.state);
                    return new StepActionResult(StepActionResultStatus.REPEAT);
                }
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("ISO_8859_1 charset is not support.", ex);
                this.gPINStep.updateState(this.state);
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
        }
        try {
            EstablishChannelResponse pinResponse = this.performPACEWithPIN(oldResults);
            if (pinResponse == null) {
                this.gPINStep.setFailedPINVerify(false);
                this.gPINStep.setWrongPINFormat(true);
                newPINField = new StepActionResult(StepActionResultStatus.REPEAT);
                return newPINField;
            }
            if (pinResponse.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                switch (pinResponse.getResult().getResultMinor()) {
                    case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordError": {
                        this.gPINStep.setFailedPINVerify(true);
                        this.gPINStep.setWrongPINFormat(false);
                        this.gPINStep.updateState(RecognizedState.PIN_activated_RC2);
                        this.state = RecognizedState.PIN_activated_RC2;
                        disconnect = new StepActionResult(StepActionResultStatus.REPEAT);
                        return disconnect;
                    }
                    case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordSuspended": {
                        this.gPINStep.setFailedPINVerify(true);
                        this.gPINStep.setWrongPINFormat(false);
                        this.gPINStep.updateState(RecognizedState.PIN_suspended);
                        this.state = RecognizedState.PIN_suspended;
                        disconnect = new StepActionResult(StepActionResultStatus.REPEAT);
                        return disconnect;
                    }
                    case "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked": {
                        this.gPINStep.setFailedPINVerify(true);
                        this.gPINStep.setWrongPINFormat(false);
                        this.gPINStep.updateState(RecognizedState.PIN_blocked);
                        this.state = RecognizedState.PIN_blocked;
                        disconnect = new StepActionResult(StepActionResultStatus.REPEAT);
                        return disconnect;
                    }
                }
                WSHelper.checkResult(pinResponse);
            }
            if (this.capturePin) {
                if (newPINValue.equals(newPINRepeatValue) && newPINValue.length() == 6) {
                    this.sendResetRetryCounter(newPINValue.getBytes(ISO_8859_1));
                }
            } else {
                ControlIFDResponse resp = this.sendModifyPIN();
                this.evaluateControlIFDResponse(resp);
            }
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateSuccessStep(this.lang.translationForKey(CHANGE_SUCCESS, new Object[0])));
            return stepActionResult;
        }
        catch (ParserConfigurationException | APDUException | IFDException ex) {
            LOG.error("An internal error occurred while trying to change the PIN", ex);
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_INTERNAL, new Object[0])));
            return stepActionResult;
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn("The encoding of the PIN is wrong.", ex);
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT);
            return stepActionResult;
        }
        catch (WSHelper.WSException ex) {
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser")) {
                LOG.error("User canceled the authentication manually or removed the card.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_USER_CANCELLATION_OR_CARD_REMOVED, new Object[0])));
                return stepActionResult;
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle")) {
                LOG.error("The SlotHandle was invalid so probably the user removed the card or an reset occurred.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_CARD_REMOVED, new Object[0])));
                return stepActionResult;
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError")) {
                LOG.error("The terminal timed out no password was entered.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_TIMEOUT, new Object[0])));
                return stepActionResult;
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordDontMatch")) {
                LOG.error("The verification of the new PIN failed.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_NON_MATCHING_PASSWORDS, new Object[0])));
                return stepActionResult;
            }
            LOG.error("An unknown error occurred while trying to change the PIN.", ex);
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_UNKNOWN, new Object[0])));
            return stepActionResult;
        }
        finally {
            DestroyChannel destChannel = new DestroyChannel();
            destChannel.setSlotHandle(this.slotHandle);
            this.dispatcher.safeDeliver(destChannel);
            disconnect = new Disconnect();
            ((Disconnect)disconnect).setSlotHandle(this.slotHandle);
            ((Disconnect)disconnect).setAction(ActionType.RESET);
            this.dispatcher.safeDeliver(disconnect);
        }
    }

    private StepActionResult performResumePIN(Map<String, ExecutionResults> oldResults) {
        try {
            EstablishChannelResponse canResponse = this.performPACEWithCAN(oldResults);
            if (canResponse == null) {
                this.gPINStep.setWrongCANFormat(true);
                this.gPINStep.setFailedCANVerify(false);
                this.gPINStep.updateState(this.state);
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            if (canResponse.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                if (canResponse.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed")) {
                    this.gPINStep.setWrongCANFormat(false);
                    this.gPINStep.setFailedCANVerify(true);
                    this.gPINStep.updateState(this.state);
                    return new StepActionResult(StepActionResultStatus.REPEAT);
                }
                WSHelper.checkResult(canResponse);
            }
            this.gPINStep.updateState(RecognizedState.PIN_resumed);
            this.state = RecognizedState.PIN_resumed;
            return new StepActionResult(StepActionResultStatus.REPEAT);
        }
        catch (ParserConfigurationException ex) {
            LOG.error("An internal error occurred while trying to resume the PIN.", ex);
            return new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_INTERNAL, new Object[0])));
        }
        catch (WSHelper.WSException ex) {
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser")) {
                LOG.error("User canceled the authentication manually or removed the card.", ex);
                return new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_USER_CANCELLATION_OR_CARD_REMOVED, new Object[0])));
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle")) {
                LOG.error("The SlotHandle was invalid so probably the user removed the card or an reset occurred.");
                return new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_CARD_REMOVED, new Object[0])));
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError")) {
                LOG.error("The terminal timed out no password was entered.", ex);
                return new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_TIMEOUT, new Object[0])));
            }
            LOG.error("An unknown error occurred while trying to verify the CAN.", ex);
            return new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_UNKNOWN, new Object[0])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepActionResult performUnblockPIN(Map<String, ExecutionResults> oldResults) {
        StepActionResult stepActionResult;
        try {
            EstablishChannelResponse pukResponse = this.performPACEWithPUK(oldResults);
            if (pukResponse == null) {
                this.gPINStep.setWrongPUKFormat(true);
                this.gPINStep.setFailedPUKVerify(false);
                this.gPINStep.updateState(this.state);
                StepActionResult stepActionResult2 = new StepActionResult(StepActionResultStatus.REPEAT);
                return stepActionResult2;
            }
            if (pukResponse.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                if (pukResponse.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed")) {
                    this.gPINStep.setWrongPUKFormat(false);
                    this.gPINStep.setFailedPUKVerify(true);
                    this.gPINStep.updateState(this.state);
                    StepActionResult stepActionResult3 = new StepActionResult(StepActionResultStatus.REPEAT);
                    return stepActionResult3;
                }
                WSHelper.checkResult(pukResponse);
            }
            ResetRetryCounter resetRetryCounter = new ResetRetryCounter(3);
            ArrayList<byte[]> responses = new ArrayList<byte[]>();
            responses.add(new byte[]{-112, 0});
            responses.add(new byte[]{105, -124});
            CardResponseAPDU resetCounterResponse = resetRetryCounter.transmit(this.dispatcher, this.slotHandle, responses);
            if (Arrays.equals(resetCounterResponse.getTrailer(), new byte[]{105, -124})) {
                this.gPINStep.updateState(RecognizedState.PUK_blocked);
                StepActionResult stepActionResult4 = new StepActionResult(StepActionResultStatus.REPEAT);
                return stepActionResult4;
            }
            if (Arrays.equals(resetCounterResponse.getTrailer(), new byte[]{-112, 0})) {
                this.gPINStep.updateState(RecognizedState.PIN_activated_RC3);
                StepActionResult stepActionResult5 = new StepActionResult(StepActionResultStatus.REPEAT, this.generateSuccessStep(this.lang.translationForKey(PUK_SUCCESS, new Object[0])));
                return stepActionResult5;
            }
            this.gPINStep.updateState(RecognizedState.UNKNOWN);
            StepActionResult stepActionResult6 = new StepActionResult(StepActionResultStatus.REPEAT);
            return stepActionResult6;
        }
        catch (ParserConfigurationException | APDUException ex) {
            LOG.error("An internal error occurred while trying to unblock the PIN.", ex);
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_INTERNAL, new Object[0])));
            return stepActionResult;
        }
        catch (WSHelper.WSException ex) {
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser")) {
                LOG.error("User canceled the authentication manually or removed the card.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_USER_CANCELLATION_OR_CARD_REMOVED, new Object[0])));
                return stepActionResult;
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError")) {
                LOG.error("The terminal timed out no password was entered.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_TIMEOUT, new Object[0])));
                return stepActionResult;
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle")) {
                LOG.error("The SlotHandle was invalid so probably the user removed the card or an reset occurred.", ex);
                stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_CARD_REMOVED, new Object[0])));
                return stepActionResult;
            }
            LOG.error("An unknown error occurred while trying to verify the PUK.", ex);
            stepActionResult = new StepActionResult(StepActionResultStatus.REPEAT, this.generateErrorStep(this.lang.translationForKey(ERROR_UNKNOWN, new Object[0])));
            return stepActionResult;
        }
        finally {
            DestroyChannel destChannel = new DestroyChannel();
            destChannel.setSlotHandle(this.slotHandle);
            this.dispatcher.safeDeliver(destChannel);
            Disconnect disconnect = new Disconnect();
            disconnect.setSlotHandle(this.slotHandle);
            disconnect.setAction(ActionType.RESET);
            this.dispatcher.safeDeliver(disconnect);
        }
    }

    private ControlIFDResponse sendModifyPIN() throws IFDException {
        PasswordAttributesType pwdAttr = GenericPINAction.create(true, PasswordTypeType.ASCII_NUMERIC, 6, 6, 6);
        pwdAttr.setPadChar(new byte[]{63});
        PCSCPinModify ctrlStruct = new PCSCPinModify(pwdAttr, StringUtils.toByteArray("002C0203"));
        byte[] structData = ctrlStruct.toBytes();
        ControlIFD controlIFD = new ControlIFD();
        controlIFD.setCommand(ByteUtils.concatenate((byte)7, structData));
        controlIFD.setSlotHandle(this.slotHandle);
        return (ControlIFDResponse)this.dispatcher.safeDeliver(controlIFD);
    }

    private CardResponseAPDU sendResetRetryCounter(byte[] newPIN) throws APDUException {
        ResetRetryCounter apdu = new ResetRetryCounter(newPIN, 3);
        return apdu.transmit(this.dispatcher, this.cHandle.getSlotHandle());
    }

    private static PasswordAttributesType create(boolean needsPadding, PasswordTypeType pwdType, int minLen, int storedLen, int maxLen) {
        PasswordAttributesType r = new PasswordAttributesType();
        r.setMinLength(BigInteger.valueOf(minLen));
        r.setStoredLength(BigInteger.valueOf(storedLen));
        r.setPwdType(pwdType);
        if (needsPadding) {
            r.getPwdFlags().add("needs-padding");
        }
        r.setMaxLength(BigInteger.valueOf(maxLen));
        return r;
    }

    private Step generateSuccessStep(String successMessage) {
        Step successStep = new Step(this.lang.translationForKey(SUCCESS_TITLE, new Object[0]));
        successStep.setReversible(false);
        Text successText = new Text(successMessage);
        successStep.getInputInfoUnits().add(successText);
        return successStep;
    }

    private Step generateErrorStep(String errorMessage) {
        Step errorStep = new Step(this.lang.translationForKey(ERROR_TITLE, new Object[0]));
        errorStep.setReversible(false);
        Text errorText = new Text(errorMessage);
        errorStep.getInputInfoUnits().add(errorText);
        return errorStep;
    }

    private void evaluateControlIFDResponse(ControlIFDResponse response) throws WSHelper.WSException {
        byte[] resp = response.getResponse();
        switch (ByteUtils.toInteger(resp)) {
            case 25761: {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Card was removed."));
                break;
            }
            case 25602: {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordDontMatch", "The entered passwords do not match."));
                break;
            }
            case 25601: {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "The user aborted the password entry."));
            }
        }
        WSHelper.checkResult(response);
    }

    private void updateConnectionHandle() {
        CardApplicationPath cPath = new CardApplicationPath();
        CardApplicationPathType cPathType = new CardApplicationPathType();
        cPath.setCardAppPathRequest(cPathType);
        CardApplicationPathResponse cPathResp = (CardApplicationPathResponse)this.dispatcher.safeDeliver(cPath);
        List<CardApplicationPathType> cRes = cPathResp.getCardAppPathResultSet().getCardApplicationPathResult();
        for (CardApplicationPathType capt : cRes) {
            CardApplicationConnect cConn = new CardApplicationConnect();
            cConn.setCardApplicationPath(capt);
            CardApplicationConnectResponse conRes = (CardApplicationConnectResponse)this.dispatcher.safeDeliver(cConn);
            String cardType = conRes.getConnectionHandle().getRecognitionInfo().getCardType();
            ConnectionHandleType cHandleNew = conRes.getConnectionHandle();
            if (cardType.equals("http://bsi.bund.de/cif/npa.xml")) {
                if (cHandleNew.getIFDName().equals(this.cHandle.getIFDName()) && !Arrays.equals(cHandleNew.getSlotHandle(), this.slotHandle)) {
                    this.cHandle = cHandleNew;
                    this.slotHandle = this.cHandle.getSlotHandle();
                    break;
                }
                if (!cHandleNew.getIFDName().equals(this.cHandle.getIFDName()) || !Arrays.equals(cHandleNew.getSlotHandle(), this.slotHandle)) continue;
                break;
            }
            CardApplicationDisconnect disconnect = new CardApplicationDisconnect();
            disconnect.setConnectionHandle(conRes.getConnectionHandle());
            disconnect.setAction(ActionType.RESET);
            this.dispatcher.safeDeliver(disconnect);
        }
    }
}

