/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.didfactory;

import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PinCompareMarkerType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PinMarkerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PinMarkerBuilder.class);
    private static final String PROTOCOL = "urn:oid:1.3.162.15480.3.0.9";
    private static final String ISONS = "urn:iso:std:iso-iec:24727:tech:schema";
    private final WSMarshaller m = WSMarshallerFactory.createInstance();
    private KeyRefType pinRef;
    private String pinValue;
    private PasswordAttributesType pwAttributes;

    public void setPinRef(KeyRefType pinRef) {
        this.pinRef = pinRef;
    }

    public void setPinValue(String pinValue) {
        this.pinValue = pinValue;
    }

    public void setPwAttributes(PasswordAttributesType pwAttributes) {
        this.pwAttributes = pwAttributes;
    }

    public PinCompareMarkerType build() {
        Document d;
        JAXBElement e;
        PinCompareMarkerType marker = new PinCompareMarkerType();
        marker.setProtocol(PROTOCOL);
        if (this.pinRef != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "PinRef"), KeyRefType.class, (Object)this.pinRef);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal PinRef element.", ex);
            }
        }
        if (this.pinValue != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "PinValue"), String.class, (Object)this.pinValue);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal PinValue element.", ex);
            }
        }
        if (this.pwAttributes != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "PasswordAttributes"), PasswordAttributesType.class, (Object)this.pinRef);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal PasswordAttributes element.", ex);
            }
        }
        return marker;
    }
}

