/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.didfactory;

import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.CryptoKeyInfoType;
import iso.std.iso_iec._24727.tech.schema.CryptoMarkerType;
import iso.std.iso_iec._24727.tech.schema.HashGenerationInfoType;
import iso.std.iso_iec._24727.tech.schema.LegacySignatureGenerationType;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CryptoMarkerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoMarkerBuilder.class);
    private static final String PROTOCOL = "urn:oid:1.3.162.15480.3.0.25";
    private static final String ISONS = "urn:iso:std:iso-iec:24727:tech:schema";
    private final WSMarshaller m = WSMarshallerFactory.createInstance();
    private AlgorithmInfoType algInfo;
    private CryptoKeyInfoType keyInfo;
    private String sigGenInfo;
    private LegacySignatureGenerationType legacySignGenInfo;
    private HashGenerationInfoType hashGenInfo;
    private ArrayList<CertificateRefType> certRefs;
    private String legacyKeyname;

    public void setAlgInfo(AlgorithmInfoType algInfo) {
        this.algInfo = algInfo;
    }

    public void setKeyInfo(CryptoKeyInfoType keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setSigGenInfo(String sigGenInfo) {
        this.legacySignGenInfo = null;
        this.sigGenInfo = sigGenInfo;
    }

    public void setLegacySignGenInfo(LegacySignatureGenerationType legacySignGenInfo) {
        this.sigGenInfo = null;
        this.legacySignGenInfo = legacySignGenInfo;
    }

    public void setHashGenInfo(HashGenerationInfoType hashGenInfo) {
        this.hashGenInfo = hashGenInfo;
    }

    public ArrayList<CertificateRefType> getCertRefs() {
        if (this.certRefs == null) {
            this.certRefs = new ArrayList();
        }
        return this.certRefs;
    }

    public void setLegacyKeyname(String legacyKeyname) {
        this.legacyKeyname = legacyKeyname;
    }

    public CryptoMarkerType build() {
        Document d;
        JAXBElement e;
        CryptoMarkerType marker = new CryptoMarkerType();
        marker.setProtocol(PROTOCOL);
        if (this.algInfo != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "AlgorithmInfo"), AlgorithmInfoType.class, (Object)this.algInfo);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal AlgorithmInfo element.", ex);
            }
        }
        if (this.keyInfo != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "KeyInfo"), CryptoKeyInfoType.class, (Object)this.keyInfo);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal KeyInfo element.", ex);
            }
        }
        if (this.sigGenInfo != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "SignatureGenerationInfo"), String.class, (Object)this.sigGenInfo);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal SignatureGenerationInfo element.", ex);
            }
        }
        if (this.legacySignGenInfo != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "LegacySignatureGenerationInfo"), LegacySignatureGenerationType.class, (Object)this.legacySignGenInfo);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal LegacySignatureGenerationInfo element.", ex);
            }
        }
        if (this.hashGenInfo != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "HashGenerationInfo"), HashGenerationInfoType.class, (Object)this.hashGenInfo);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal HashGenerationInfo element.", ex);
            }
        }
        for (CertificateRefType certRef : this.getCertRefs()) {
            try {
                JAXBElement e2 = new JAXBElement(new QName(ISONS, "CertificateRef"), CertificateRefType.class, (Object)certRef);
                Document d2 = this.m.marshal(e2);
                marker.getAny().add(d2.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal CertificateRef element.", ex);
            }
        }
        if (this.legacyKeyname != null) {
            try {
                e = new JAXBElement(new QName(ISONS, "LegacyKeyName"), String.class, (Object)this.legacyKeyname);
                d = this.m.marshal(e);
                marker.getAny().add(d.getDocumentElement());
            }
            catch (MarshallingTypeException ex) {
                LOG.error("Failed to marshal LegacyKeyName element.", ex);
            }
        }
        return marker;
    }
}

