/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.config;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.OpenecardProperties;
import org.openecard.mdlw.sal.config.CardSpecType;
import org.openecard.mdlw.sal.config.LibSpecType;
import org.openecard.mdlw.sal.config.MiddlewareConfig;
import org.openecard.mdlw.sal.config.MiddlewareProperties;
import org.openecard.mdlw.sal.config.MiddlewareSpecType;

public class MiddlewareSALConfig {
    private final MiddlewareSpecType mwSpec;
    private final MiddlewareConfig mwConfig;
    private final boolean internal;

    public MiddlewareSALConfig(MiddlewareConfig mwConfig, MiddlewareSpecType mwSpec, boolean internal) {
        this.mwConfig = mwConfig;
        this.mwSpec = mwSpec;
        this.internal = internal;
    }

    public String getMiddlewareName() {
        return this.mwSpec.getMiddlewareName();
    }

    public boolean isSALRequired() {
        return this.mwSpec.isRequired();
    }

    public boolean isDisabled() {
        String key = this.mwSpec.getMiddlewareName() + ".enabled";
        boolean enabledProp = Boolean.parseBoolean(OpenecardProperties.properties().getProperty(key, "false"));
        boolean forceEnable = MiddlewareProperties.isForceLoadInternalModules() && this.internal;
        boolean enabled = enabledProp || forceEnable;
        return this.mwSpec.isDisabled() || !enabled;
    }

    public String getLibName() {
        return this.getLibSpec().getLibName();
    }

    public List<String> getSearchPaths() {
        return Collections.unmodifiableList(this.getLibSpec().getSearchPath());
    }

    public List<String> getX32SearchPaths() {
        return Collections.unmodifiableList(this.getLibSpec().getX32searchPath());
    }

    public List<String> getX64SearchPaths() {
        return Collections.unmodifiableList(this.getLibSpec().getX64searchPath());
    }

    @Nonnull
    protected LibSpecType getLibSpec() {
        LibSpecType defaultSpec = null;
        String osName = System.getProperty("os.name", "");
        for (LibSpecType spec : this.mwSpec.getLibSpec()) {
            if (spec.getOperatingSystem() == null) {
                defaultSpec = spec;
                continue;
            }
            if (!osName.startsWith(spec.getOperatingSystem())) continue;
            return spec;
        }
        if (defaultSpec == null) {
            throw new NullPointerException("No default LibSpec defined in the XML config.");
        }
        return defaultSpec;
    }

    public boolean isCardTypeKnown(String cardType) {
        for (CardSpecType cardSpec : this.mwSpec.getCardConfig().getCardSpecs()) {
            if (!cardSpec.getObjectIdentifier().equals(cardType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public CardInfoType getCardInfo(String oIdentifier) {
        for (CardSpecType cardSpec : this.mwSpec.getCardConfig().getCardSpecs()) {
            if (!cardSpec.getObjectIdentifier().equals(oIdentifier)) continue;
            return this.mwConfig.getCardInfoByCardSpec(cardSpec);
        }
        return null;
    }

    @Nullable
    public InputStream getCardImage(String oIdentifier) {
        for (CardSpecType cardSpec : this.mwSpec.getCardConfig().getCardSpecs()) {
            if (!cardSpec.getObjectIdentifier().equals(oIdentifier)) continue;
            return this.mwConfig.getCardImage(cardSpec.getCardImageName());
        }
        return null;
    }

    @Nullable
    public String mapMiddlewareType(@Nonnull String middlewareCardType) {
        for (CardSpecType spec : this.mwSpec.getCardConfig().getCardSpecs()) {
            String mwName = spec.getMiddlewareName();
            if (!middlewareCardType.equals(mwName)) continue;
            return spec.getObjectIdentifier();
        }
        return null;
    }

    public boolean isATRKnown(@Nullable byte[] atr) {
        if (atr != null) {
            for (CardSpecType spec : this.mwSpec.getCardConfig().getCardSpecs()) {
                boolean matches = this.compareATR(atr, spec.getAtr(), spec.getMask());
                if (!matches) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareATR(@Nonnull byte[] atr, @Nullable byte[] refAtr, @Nullable byte[] mask) {
        if (refAtr != null) {
            if (mask == null) {
                mask = new byte[refAtr.length];
                Arrays.fill(mask, (byte)-1);
            }
            if (atr.length > refAtr.length) {
                return false;
            }
            for (int i = 0; i < refAtr.length; ++i) {
                byte orig;
                byte ref;
                if (!(i < atr.length ? (ref = (byte)(refAtr[i] & mask[i])) != (orig = (byte)(atr[i] & mask[i])) : mask[i] != 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

