/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import org.openecard.common.I18n;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.PinEntryStep;
import org.openecard.mdlw.sal.exceptions.CryptokiException;

public class PinEntryDialog {
    private static final I18n LANG = I18n.getTranslation("pinplugin");
    private final UserConsent gui;
    private final boolean protectedAuthPath;
    private final MwSession session;
    private PinEntryStep pinStep;

    public PinEntryDialog(UserConsent gui, boolean protectedAuthPath, MwSession session) {
        this.gui = gui;
        this.protectedAuthPath = protectedAuthPath;
        this.session = session;
    }

    public ResultStatus show() throws CryptokiException {
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createUserConsentDescription());
        ExecutionEngine exec = new ExecutionEngine(ucr);
        ResultStatus result = exec.process();
        return result;
    }

    private UserConsentDescription createUserConsentDescription() throws CryptokiException {
        String title = LANG.translationForKey("action.changepin.userconsent.pinstep.title", new Object[0]);
        UserConsentDescription uc = new UserConsentDescription(title, "pin_entry_dialog");
        this.pinStep = new PinEntryStep(this.protectedAuthPath, this.session);
        uc.getSteps().add(this.pinStep);
        return uc;
    }

    boolean isPinAuthenticated() {
        return this.pinStep.isPinAuthenticated();
    }

    boolean isPinBlocked() {
        return this.pinStep.isPinBlocked();
    }
}

