/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.PinChangeStep;
import org.openecard.mdlw.sal.PinChangeStepAction;
import org.openecard.mdlw.sal.exceptions.CryptokiException;

public class PinChangeDialog {
    private final UserConsent gui;
    private final boolean protectedAuthPath;
    private final MwSession session;
    private PinChangeStep pinStep;

    public PinChangeDialog(UserConsent gui, boolean protectedAuthPath, MwSession session) {
        this.gui = gui;
        this.protectedAuthPath = protectedAuthPath;
        this.session = session;
    }

    public ResultStatus show() throws CryptokiException {
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createUserConsentDescription());
        ExecutionEngine exec = new ExecutionEngine(ucr);
        ResultStatus result = exec.process();
        return result;
    }

    private UserConsentDescription createUserConsentDescription() throws CryptokiException {
        UserConsentDescription uc = new UserConsentDescription("PIN Management", "pin_change_dialog");
        this.pinStep = new PinChangeStep(this.protectedAuthPath, this.session);
        this.pinStep.setAction(new PinChangeStepAction(this.pinStep));
        uc.getSteps().add(this.pinStep);
        return uc;
    }
}

