/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.ThreadTerminateException;
import org.openecard.crypto.common.SignatureAlgorithms;
import org.openecard.mdlw.sal.AttributeUtils;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwAbstractKey;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.cryptoki.CK_MECHANISM;
import org.openecard.mdlw.sal.cryptoki.CK_RSA_PKCS_PSS_PARAMS;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.InvalidArgumentsException;
import org.openecard.mdlw.sal.struct.CkAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwPrivateKey
extends MwAbstractKey {
    private static final Logger LOG = LoggerFactory.getLogger(MwPrivateKey.class);
    private final String keyLabel = this.loadAttrValueLabel();
    private final Boolean sensitive = this.loadAttrValueSensitive();
    private final Boolean decrypt = this.loadAttrValueDecrypt();
    private final Boolean sign = this.loadAttrValueSign();
    private final Boolean singRecover = this.loadAttrValueSignRecover();
    private final Boolean unwrap = this.loadAttrValueUnwrap();
    private final Boolean extractable = this.loadAttrValueExtractable();
    private final Boolean alwaysSensitive = this.loadAttrValueAlwaysSensitive();
    private final Boolean neverExtractable = this.loadAttrValueNeverExtractable();
    private final Boolean wrapWithTrusted = this.loadAttrValueWrapWithTrusted();
    private final Long unwrapTemplate = this.loadAttrValueUnwrapTemplate();
    private final Boolean alwaysAuthenticate = this.loadAttrValueAlwaysAuthenticate();

    public MwPrivateKey(long objectHandle, MiddleWareWrapper mw, MwSession mwSession) throws CryptokiException {
        super(objectHandle, mw, mwSession);
    }

    private Boolean loadAttrValueAlwaysAuthenticate() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(514);
        return raw != null ? AttributeUtils.getBool(raw) : false;
    }

    private Long loadAttrValueUnwrapTemplate() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(1073742354);
        return raw != null ? Long.valueOf(AttributeUtils.getLong(raw)) : null;
    }

    private Boolean loadAttrValueWrapWithTrusted() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(528);
        return raw != null ? AttributeUtils.getBool(raw) : false;
    }

    private Boolean loadAttrValueNeverExtractable() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 356L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueAlwaysSensitive() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 357L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueExtractable() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 354L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueUnwrap() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 263L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueSignRecover() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 265L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueSign() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 264L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueDecrypt() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 261L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueSensitive() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 259L);
        return AttributeUtils.getBool(raw);
    }

    public byte[] sign(SignatureAlgorithms mechanism, byte[] data) throws CryptokiException {
        return this.sign(mechanism.getPkcs11Mechanism(), data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(long mechanism, byte[] data) throws CryptokiException {
        NativeLong paramsPtrSize;
        Pointer paramsPtr;
        if (this.isPSSAlg((int)mechanism)) {
            LOG.debug("Preparing PSS Parameters.");
            NativeLong hashAlg = new NativeLong((long)this.getHashAlg((int)mechanism, data), true);
            NativeLong mgfAlg = new NativeLong((long)this.getMgf1Alg(hashAlg.intValue()), true);
            NativeLong sLen = new NativeLong((long)this.getHashLen(hashAlg.intValue()), true);
            CK_RSA_PKCS_PSS_PARAMS pssParams = new CK_RSA_PKCS_PSS_PARAMS(hashAlg, mgfAlg, sLen);
            pssParams.write();
            paramsPtr = pssParams.getPointer();
            paramsPtrSize = new NativeLong((long)pssParams.size(), true);
        } else {
            paramsPtr = Pointer.NULL;
            paramsPtrSize = new NativeLong(0L, true);
        }
        CK_MECHANISM pMechanism = new CK_MECHANISM(new NativeLong(mechanism, true), paramsPtr, paramsPtrSize);
        try (MiddleWareWrapper.LockedMiddlewareWrapper lmw = this.mw.lock();){
            lmw.signInit(this.session.getSessionId(), pMechanism, this.objectHandle);
            byte[] byArray = lmw.sign(this.session.getSessionId(), data);
            return byArray;
        }
        catch (InterruptedException ex) {
            throw new ThreadTerminateException("Thread interrupted while waiting for Middleware lock.", ex);
        }
    }

    private boolean isPSSAlg(int mechanism) {
        switch (mechanism) {
            case 13: 
            case 14: 
            case 67: 
            case 68: 
            case 69: 
            case 71: {
                return true;
            }
        }
        return false;
    }

    private int getHashAlg(int pssMechanism, byte[] message) throws CryptokiException {
        switch (pssMechanism) {
            case 13: {
                return this.getHashAlg(message);
            }
            case 14: {
                return 544;
            }
            case 71: {
                return 597;
            }
            case 67: {
                return 592;
            }
            case 68: {
                return 608;
            }
            case 69: {
                return 624;
            }
        }
        throw new IllegalStateException("Hash determination triggered for non PSS mechanism.");
    }

    private int getHashAlg(byte[] hash) throws CryptokiException {
        switch (hash.length) {
            case 20: {
                return 544;
            }
            case 28: {
                return 597;
            }
            case 32: {
                return 592;
            }
            case 48: {
                return 608;
            }
            case 64: {
                return 624;
            }
        }
        String msg = "Size of the Hash does not match any supported algorithm.";
        throw new InvalidArgumentsException(msg, 113L);
    }

    private int getHashLen(int hashAlg) {
        switch (hashAlg) {
            case 544: {
                return 20;
            }
            case 597: {
                return 28;
            }
            case 592: {
                return 32;
            }
            case 608: {
                return 48;
            }
            case 624: {
                return 64;
            }
        }
        return 20;
    }

    private int getMgf1Alg(int hashAlg) throws CryptokiException {
        switch (hashAlg) {
            case 544: {
                return 1;
            }
            case 597: {
                return 5;
            }
            case 592: {
                return 2;
            }
            case 608: {
                return 3;
            }
            case 624: {
                return 4;
            }
        }
        String msg = "Hash algorithm is not supported.";
        throw new InvalidArgumentsException(msg, 113L);
    }

    private String loadAttrValueLabel() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 3L);
        return AttributeUtils.getString(raw);
    }

    public long getObjectHandle() {
        return this.objectHandle;
    }

    MiddleWareWrapper getMW() {
        return this.mw;
    }

    public MwSession getSession() {
        return this.session;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public Boolean getSensitive() {
        return this.sensitive;
    }

    public Boolean getDecrypt() {
        return this.decrypt;
    }

    public Boolean getSign() {
        return this.sign;
    }

    public Boolean getSignRecover() {
        return this.singRecover;
    }

    public Boolean getUnwrap() {
        return this.unwrap;
    }

    public Boolean getExtractable() {
        return this.extractable;
    }

    public Boolean getAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public Boolean getNeverExtractable() {
        return this.neverExtractable;
    }

    @Nonnull
    public Boolean getWrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    @Nullable
    public Long getUnwrapTemplate() {
        return this.unwrapTemplate;
    }

    @Nonnull
    public Boolean getAlwaysAuthenticate() {
        return this.alwaysAuthenticate;
    }

    public String toString() {
        return "PKCS#11 Private Key: {label=" + this.getKeyLabel() + ", type=" + this.getKeyTypeName() + "}";
    }
}

