/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwSlot;
import org.openecard.mdlw.sal.config.MiddlewareSALConfig;
import org.openecard.mdlw.sal.enums.TokenState;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.FinalizationException;
import org.openecard.mdlw.sal.exceptions.InitializationException;
import org.openecard.mdlw.sal.struct.CkInfo;
import org.openecard.mdlw.sal.struct.CkSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwModule {
    private static final Logger LOG = LoggerFactory.getLogger(MwModule.class);
    private final MiddlewareSALConfig mwSALConfig;
    private MiddleWareWrapper mw;

    public MwModule(MiddlewareSALConfig mwSALConfig) {
        this.mwSALConfig = mwSALConfig;
    }

    public void initialize() throws UnsatisfiedLinkError, InitializationException {
        try {
            this.mw = new MiddleWareWrapper(this.mwSALConfig);
            this.mw.initialize();
        }
        catch (CryptokiException ex) {
            throw new InitializationException("Failed to initalize PKCS#11 middleware.", ex.getErrorCode());
        }
    }

    public void destroy() throws FinalizationException {
        try {
            this.mw.destroy();
        }
        catch (CryptokiException ex) {
            throw new FinalizationException("Failed to shutdown PKCS#11 middleware.", ex.getErrorCode());
        }
    }

    public CkInfo getInfo() throws CryptokiException {
        return this.mw.getInfo();
    }

    public List<MwSlot> getSlotList(TokenState tokenState) throws CryptokiException {
        return this.getSlotList(tokenState.getValue());
    }

    public List<MwSlot> getSlotList(boolean tokenPresent) throws CryptokiException {
        ArrayList<MwSlot> slots = new ArrayList<MwSlot>();
        for (long slotId : this.mw.getSlotList(tokenPresent)) {
            try {
                CkSlot slotInfo = this.mw.getSlotInfo(slotId);
                MwSlot slot = new MwSlot(this.mw, this, slotInfo);
                slots.add(slot);
            }
            catch (CryptokiException ex) {
                long code = ex.getErrorCode();
                if (code != 48L && code != 224L && code != 50L) {
                    throw ex;
                }
                LOG.info("Skipping slot {} due to recoverable error {}.", (Object)slotId, (Object)code);
            }
        }
        return Collections.unmodifiableList(slots);
    }

    public MiddlewareSALConfig getMiddlewareSALConfig() {
        return this.mwSALConfig;
    }

    public long waitForSlotEvent(int flag) throws CryptokiException {
        try {
            return this.mw.waitForSlotEvent(flag);
        }
        catch (CryptokiException ex) {
            if (flag == 1 && ex.getErrorCode() == 8L) {
                return -1L;
            }
            throw ex;
        }
    }
}

