/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import org.openecard.mdlw.sal.AttributeUtils;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.struct.CkAttribute;

public class MwData {
    private final long objectHandle;
    private final MiddleWareWrapper mw;
    private final MwSession session;
    private final String application;
    private final byte[] value;
    private final byte[] objectId;

    public MwData(long objectHandle, MiddleWareWrapper mw, MwSession mwSession) throws CryptokiException {
        this.objectHandle = objectHandle;
        this.mw = mw;
        this.session = mwSession;
        this.application = this.loadAttrValApp();
        this.value = this.loadAttrValValue();
        this.objectId = this.loadAttrValObjectID();
    }

    private String loadAttrValApp() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 16L);
        return AttributeUtils.getString(raw);
    }

    private byte[] loadAttrValValue() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 17L);
        return AttributeUtils.getBytes(raw);
    }

    private byte[] loadAttrValObjectID() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 18L);
        return AttributeUtils.getBytes(raw);
    }

    public String getApplicationName() {
        return this.application;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getObjectID() {
        return this.objectId;
    }
}

